/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.model.AssemblyConstraintSupport;
import gov.nist.secauto.metaschema.model.MarkupStringConverter;
import gov.nist.secauto.metaschema.model.ModelFactory;
import gov.nist.secauto.metaschema.model.XmlFlagContainerSupport;
import gov.nist.secauto.metaschema.model.XmlModelContainerSupport;
import gov.nist.secauto.metaschema.model.XmlModelParser;
import gov.nist.secauto.metaschema.model.common.AbstractAssemblyInstance;
import gov.nist.secauto.metaschema.model.common.IAssemblyDefinition;
import gov.nist.secauto.metaschema.model.common.IAssemblyInstance;
import gov.nist.secauto.metaschema.model.common.IChoiceInstance;
import gov.nist.secauto.metaschema.model.common.IFieldInstance;
import gov.nist.secauto.metaschema.model.common.IFlagInstance;
import gov.nist.secauto.metaschema.model.common.IInlineDefinition;
import gov.nist.secauto.metaschema.model.common.IMetaschema;
import gov.nist.secauto.metaschema.model.common.IModelContainer;
import gov.nist.secauto.metaschema.model.common.IModelInstance;
import gov.nist.secauto.metaschema.model.common.INamedModelInstance;
import gov.nist.secauto.metaschema.model.common.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.model.common.ModuleScopeEnum;
import gov.nist.secauto.metaschema.model.common.XmlGroupAsBehavior;
import gov.nist.secauto.metaschema.model.common.constraint.IAllowedValuesConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IAssemblyConstraintSupport;
import gov.nist.secauto.metaschema.model.common.constraint.ICardinalityConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IExpectConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IIndexConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IIndexHasKeyConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IMatchesConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IUniqueConstraint;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.model.common.util.CollectionUtil;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.model.xmlbeans.DefineAssemblyConstraintsType;
import gov.nist.secauto.metaschema.model.xmlbeans.InlineAssemblyDefinitionType;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

class XmlInlineAssemblyDefinition
extends AbstractAssemblyInstance {
    @NonNull
    private final InlineAssemblyDefinitionType xmlAssembly;
    @NonNull
    private final InternalAssemblyDefinition assemblyDefinition;

    public XmlInlineAssemblyDefinition(@NonNull InlineAssemblyDefinitionType xmlAssembly, @NonNull IModelContainer parent) {
        super(parent);
        this.xmlAssembly = xmlAssembly;
        this.assemblyDefinition = new InternalAssemblyDefinition();
    }

    protected InlineAssemblyDefinitionType getXmlAssembly() {
        return this.xmlAssembly;
    }

    public InternalAssemblyDefinition getDefinition() {
        return this.assemblyDefinition;
    }

    public String getFormalName() {
        return this.getXmlAssembly().isSetFormalName() ? this.getXmlAssembly().getFormalName() : null;
    }

    public MarkupLine getDescription() {
        return this.getXmlAssembly().isSetDescription() ? MarkupStringConverter.toMarkupString(this.getXmlAssembly().getDescription()) : null;
    }

    public Map<QName, Set<String>> getProperties() {
        return ModelFactory.toProperties(CollectionUtil.listOrEmpty(this.getXmlAssembly().getPropList()));
    }

    public String getName() {
        return this.getXmlAssembly().getName();
    }

    public String getUseName() {
        return null;
    }

    public String getGroupAsName() {
        return this.getXmlAssembly().isSetGroupAs() ? this.getXmlAssembly().getGroupAs().getName() : null;
    }

    public int getMinOccurs() {
        return XmlModelParser.getMinOccurs(this.getXmlAssembly().getMinOccurs());
    }

    public int getMaxOccurs() {
        return XmlModelParser.getMaxOccurs(this.getXmlAssembly().getMaxOccurs());
    }

    public JsonGroupAsBehavior getJsonGroupAsBehavior() {
        return XmlModelParser.getJsonGroupAsBehavior(this.getXmlAssembly().getGroupAs());
    }

    public XmlGroupAsBehavior getXmlGroupAsBehavior() {
        return XmlModelParser.getXmlGroupAsBehavior(this.getXmlAssembly().getGroupAs());
    }

    public MarkupMultiline getRemarks() {
        return this.getXmlAssembly().isSetRemarks() ? MarkupStringConverter.toMarkupString(this.getXmlAssembly().getRemarks()) : null;
    }

    public Object getValue(@NonNull Object parentValue) {
        return null;
    }

    public Collection<?> getItemValues(Object instanceValue) {
        return Collections.emptyList();
    }

    private final class InternalAssemblyDefinition
    implements IAssemblyDefinition,
    IInlineDefinition<XmlInlineAssemblyDefinition> {
        private XmlFlagContainerSupport flagContainer;
        private XmlModelContainerSupport modelContainer;
        private IAssemblyConstraintSupport constraints;

        private InternalAssemblyDefinition() {
        }

        public boolean isInline() {
            return true;
        }

        public XmlInlineAssemblyDefinition getInlineInstance() {
            return XmlInlineAssemblyDefinition.this;
        }

        public String getFormalName() {
            return XmlInlineAssemblyDefinition.this.getFormalName();
        }

        public MarkupLine getDescription() {
            return XmlInlineAssemblyDefinition.this.getDescription();
        }

        @NonNull
        public Map<QName, Set<String>> getProperties() {
            return XmlInlineAssemblyDefinition.this.getProperties();
        }

        public ModuleScopeEnum getModuleScope() {
            return ModuleScopeEnum.LOCAL;
        }

        public String getName() {
            return XmlInlineAssemblyDefinition.this.getName();
        }

        public String getUseName() {
            return null;
        }

        public boolean isRoot() {
            return false;
        }

        public String getRootName() {
            return null;
        }

        public boolean hasJsonKey() {
            return XmlInlineAssemblyDefinition.this.getXmlAssembly().isSetJsonKey();
        }

        public IFlagInstance getJsonKeyFlagInstance() {
            IFlagInstance retval = null;
            if (this.hasJsonKey()) {
                retval = this.getFlagInstanceByName(XmlInlineAssemblyDefinition.this.getXmlAssembly().getJsonKey().getFlagRef());
            }
            return retval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private XmlFlagContainerSupport initFlagContainer() {
            InternalAssemblyDefinition internalAssemblyDefinition = this;
            synchronized (internalAssemblyDefinition) {
                if (this.flagContainer == null) {
                    this.flagContainer = new XmlFlagContainerSupport(XmlInlineAssemblyDefinition.this.getXmlAssembly(), (IAssemblyDefinition)this);
                }
                return this.flagContainer;
            }
        }

        @NonNull
        private Map<String, ? extends IFlagInstance> getFlagInstanceMap() {
            return this.initFlagContainer().getFlagInstanceMap();
        }

        public IFlagInstance getFlagInstanceByName(String name) {
            return this.getFlagInstanceMap().get(name);
        }

        public Collection<? extends IFlagInstance> getFlagInstances() {
            return this.getFlagInstanceMap().values();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private XmlModelContainerSupport initModelContainer() {
            InternalAssemblyDefinition internalAssemblyDefinition = this;
            synchronized (internalAssemblyDefinition) {
                if (this.modelContainer == null) {
                    this.modelContainer = new XmlModelContainerSupport(XmlInlineAssemblyDefinition.this.getXmlAssembly(), (IModelContainer)this);
                }
                return this.modelContainer;
            }
        }

        private Map<String, ? extends INamedModelInstance> getNamedModelInstanceMap() {
            return this.initModelContainer().getNamedModelInstanceMap();
        }

        @Nullable
        public INamedModelInstance getModelInstanceByName(String name) {
            return this.getNamedModelInstanceMap().get(name);
        }

        @NonNull
        public Collection<? extends INamedModelInstance> getNamedModelInstances() {
            return this.getNamedModelInstanceMap().values();
        }

        private Map<String, ? extends IFieldInstance> getFieldInstanceMap() {
            return this.initModelContainer().getFieldInstanceMap();
        }

        public IFieldInstance getFieldInstanceByName(String name) {
            return this.getFieldInstanceMap().get(name);
        }

        public Collection<? extends IFieldInstance> getFieldInstances() {
            return this.getFieldInstanceMap().values();
        }

        private Map<String, ? extends IAssemblyInstance> getAssemblyInstanceMap() {
            return this.initModelContainer().getAssemblyInstanceMap();
        }

        public IAssemblyInstance getAssemblyInstanceByName(String name) {
            return this.getAssemblyInstanceMap().get(name);
        }

        public Collection<? extends IAssemblyInstance> getAssemblyInstances() {
            return this.getAssemblyInstanceMap().values();
        }

        public List<? extends IChoiceInstance> getChoiceInstances() {
            return this.initModelContainer().getChoiceInstances();
        }

        public List<? extends IModelInstance> getModelInstances() {
            return this.initModelContainer().getModelInstances();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IAssemblyConstraintSupport initModelConstraints() {
            InternalAssemblyDefinition internalAssemblyDefinition = this;
            synchronized (internalAssemblyDefinition) {
                if (this.constraints == null) {
                    this.constraints = XmlInlineAssemblyDefinition.this.getXmlAssembly().isSetConstraint() ? new AssemblyConstraintSupport((DefineAssemblyConstraintsType)ObjectUtils.notNull((Object)XmlInlineAssemblyDefinition.this.getXmlAssembly().getConstraint()), IConstraint.ExternalModelSource.instance((URI)((URI)ObjectUtils.requireNonNull((Object)this.getContainingMetaschema().getLocation())))) : new AssemblyConstraintSupport();
                }
                return this.constraints;
            }
        }

        public List<? extends IConstraint> getConstraints() {
            return this.initModelConstraints().getConstraints();
        }

        public List<? extends IAllowedValuesConstraint> getAllowedValuesConstraints() {
            return this.initModelConstraints().getAllowedValuesConstraints();
        }

        public List<? extends IMatchesConstraint> getMatchesConstraints() {
            return this.initModelConstraints().getMatchesConstraints();
        }

        public List<? extends IIndexHasKeyConstraint> getIndexHasKeyConstraints() {
            return this.initModelConstraints().getIndexHasKeyConstraints();
        }

        public List<? extends IExpectConstraint> getExpectConstraints() {
            return this.initModelConstraints().getExpectConstraints();
        }

        public List<? extends IIndexConstraint> getIndexConstraints() {
            return this.initModelConstraints().getIndexConstraints();
        }

        public List<? extends IUniqueConstraint> getUniqueConstraints() {
            return this.initModelConstraints().getUniqueConstraints();
        }

        public List<? extends ICardinalityConstraint> getHasCardinalityConstraints() {
            return this.initModelConstraints().getHasCardinalityConstraints();
        }

        public void addConstraint(@NonNull IAllowedValuesConstraint constraint) {
            this.initModelConstraints().addConstraint(constraint);
        }

        public void addConstraint(@NonNull IMatchesConstraint constraint) {
            this.initModelConstraints().addConstraint(constraint);
        }

        public void addConstraint(@NonNull IIndexHasKeyConstraint constraint) {
            this.initModelConstraints().addConstraint(constraint);
        }

        public void addConstraint(@NonNull IExpectConstraint constraint) {
            this.initModelConstraints().addConstraint(constraint);
        }

        public void addConstraint(@NonNull IIndexConstraint constraint) {
            this.initModelConstraints().addConstraint(constraint);
        }

        public void addConstraint(@NonNull IUniqueConstraint constraint) {
            this.initModelConstraints().addConstraint(constraint);
        }

        public void addConstraint(@NonNull ICardinalityConstraint constraint) {
            this.initModelConstraints().addConstraint(constraint);
        }

        public MarkupMultiline getRemarks() {
            return XmlInlineAssemblyDefinition.this.getRemarks();
        }

        public IMetaschema getContainingMetaschema() {
            return XmlInlineAssemblyDefinition.super.getContainingDefinition().getContainingMetaschema();
        }
    }
}

