/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.model.MarkupStringConverter;
import gov.nist.secauto.metaschema.model.ModelFactory;
import gov.nist.secauto.metaschema.model.ValueConstraintSupport;
import gov.nist.secauto.metaschema.model.XmlFlagContainerSupport;
import gov.nist.secauto.metaschema.model.XmlModelParser;
import gov.nist.secauto.metaschema.model.common.AbstractFieldInstance;
import gov.nist.secauto.metaschema.model.common.IFieldDefinition;
import gov.nist.secauto.metaschema.model.common.IFlagInstance;
import gov.nist.secauto.metaschema.model.common.IInlineDefinition;
import gov.nist.secauto.metaschema.model.common.IMetaschema;
import gov.nist.secauto.metaschema.model.common.IModelContainer;
import gov.nist.secauto.metaschema.model.common.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.model.common.ModuleScopeEnum;
import gov.nist.secauto.metaschema.model.common.XmlGroupAsBehavior;
import gov.nist.secauto.metaschema.model.common.constraint.IAllowedValuesConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IExpectConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IIndexHasKeyConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IMatchesConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IValueConstraintSupport;
import gov.nist.secauto.metaschema.model.common.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.model.common.datatype.adapter.MetaschemaDataTypeProvider;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupDataTypeProvider;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.model.common.util.CollectionUtil;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.model.xmlbeans.DefineFieldConstraintsType;
import gov.nist.secauto.metaschema.model.xmlbeans.InlineFieldDefinitionType;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

class XmlInlineFieldDefinition
extends AbstractFieldInstance {
    @NonNull
    private final InlineFieldDefinitionType xmlField;
    @NonNull
    private final InternalFieldDefinition fieldDefinition;

    public XmlInlineFieldDefinition(@NonNull InlineFieldDefinitionType xmlField, @NonNull IModelContainer parent) {
        super(parent);
        this.xmlField = xmlField;
        this.fieldDefinition = new InternalFieldDefinition();
    }

    @NonNull
    protected final InlineFieldDefinitionType getXmlField() {
        return this.xmlField;
    }

    public InternalFieldDefinition getDefinition() {
        return this.fieldDefinition;
    }

    public IMetaschema getContainingMetaschema() {
        return this.getContainingDefinition().getContainingMetaschema();
    }

    public boolean isInXmlWrapped() {
        boolean retval;
        if (MarkupDataTypeProvider.MARKUP_MULTILINE.equals(this.getDefinition().getJavaTypeAdapter())) {
            retval = true;
            if (this.getXmlField().isSetInXml()) {
                retval = this.getXmlField().getInXml();
            }
        } else {
            retval = true;
        }
        return retval;
    }

    public String getFormalName() {
        return this.getXmlField().isSetFormalName() ? this.getXmlField().getFormalName() : null;
    }

    public MarkupLine getDescription() {
        return this.getXmlField().isSetDescription() ? MarkupStringConverter.toMarkupString(this.getXmlField().getDescription()) : null;
    }

    public Map<QName, Set<String>> getProperties() {
        return ModelFactory.toProperties(CollectionUtil.listOrEmpty(this.getXmlField().getPropList()));
    }

    public String getName() {
        return this.getXmlField().getName();
    }

    public String getUseName() {
        return null;
    }

    public String getGroupAsName() {
        return this.getXmlField().isSetGroupAs() ? this.getXmlField().getGroupAs().getName() : null;
    }

    public int getMinOccurs() {
        return XmlModelParser.getMinOccurs(this.getXmlField().getMinOccurs());
    }

    public int getMaxOccurs() {
        return XmlModelParser.getMaxOccurs(this.getXmlField().getMaxOccurs());
    }

    public JsonGroupAsBehavior getJsonGroupAsBehavior() {
        return XmlModelParser.getJsonGroupAsBehavior(this.getXmlField().getGroupAs());
    }

    public XmlGroupAsBehavior getXmlGroupAsBehavior() {
        return XmlModelParser.getXmlGroupAsBehavior(this.getXmlField().getGroupAs());
    }

    public MarkupMultiline getRemarks() {
        return this.getXmlField().isSetRemarks() ? MarkupStringConverter.toMarkupString(this.getXmlField().getRemarks()) : null;
    }

    public Object getValue(@NonNull Object parentValue) {
        return null;
    }

    public Collection<?> getItemValues(Object instanceValue) {
        return Collections.emptyList();
    }

    private final class InternalFieldDefinition
    implements IFieldDefinition,
    IInlineDefinition<XmlInlineFieldDefinition> {
        @Nullable
        private final Object defaultValue;
        private XmlFlagContainerSupport flagContainer;
        private IValueConstraintSupport constraints;

        private InternalFieldDefinition() {
            Object defaultValue = null;
            if (XmlInlineFieldDefinition.this.getXmlField().isSetDefault()) {
                defaultValue = this.getJavaTypeAdapter().parse((String)ObjectUtils.requireNonNull((Object)XmlInlineFieldDefinition.this.getXmlField().getDefault()));
            }
            this.defaultValue = defaultValue;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public boolean isInline() {
            return true;
        }

        public XmlInlineFieldDefinition getInlineInstance() {
            return XmlInlineFieldDefinition.this;
        }

        public String getFormalName() {
            return XmlInlineFieldDefinition.this.getFormalName();
        }

        public MarkupLine getDescription() {
            return XmlInlineFieldDefinition.this.getDescription();
        }

        @NonNull
        public Map<QName, Set<String>> getProperties() {
            return XmlInlineFieldDefinition.this.getProperties();
        }

        public ModuleScopeEnum getModuleScope() {
            return ModuleScopeEnum.LOCAL;
        }

        public String getName() {
            return XmlInlineFieldDefinition.this.getName();
        }

        public String getUseName() {
            return null;
        }

        public IDataTypeAdapter<?> getJavaTypeAdapter() {
            return XmlInlineFieldDefinition.this.getXmlField().isSetAsType() ? XmlInlineFieldDefinition.this.getXmlField().getAsType() : MetaschemaDataTypeProvider.DEFAULT_DATA_TYPE;
        }

        public boolean hasJsonValueKeyFlagInstance() {
            return XmlInlineFieldDefinition.this.getXmlField().isSetJsonValueKeyFlag() && XmlInlineFieldDefinition.this.getXmlField().getJsonValueKeyFlag().isSetFlagRef();
        }

        public IFlagInstance getJsonValueKeyFlagInstance() {
            IFlagInstance retval = null;
            if (XmlInlineFieldDefinition.this.getXmlField().isSetJsonValueKeyFlag() && XmlInlineFieldDefinition.this.getXmlField().getJsonValueKeyFlag().isSetFlagRef()) {
                retval = this.getFlagInstanceByName(XmlInlineFieldDefinition.this.getXmlField().getJsonValueKeyFlag().getFlagRef());
            }
            return retval;
        }

        public String getJsonValueKeyName() {
            String retval = null;
            if (XmlInlineFieldDefinition.this.getXmlField().isSetJsonValueKey()) {
                retval = XmlInlineFieldDefinition.this.getXmlField().getJsonValueKey();
            }
            if (retval == null || retval.isEmpty()) {
                retval = this.getJavaTypeAdapter().getDefaultJsonValueKey();
            }
            return retval;
        }

        public boolean isCollapsible() {
            return XmlInlineFieldDefinition.this.getXmlField().isSetCollapsible() ? XmlInlineFieldDefinition.this.getXmlField().getCollapsible() : false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private XmlFlagContainerSupport initFlagContainer() {
            InternalFieldDefinition internalFieldDefinition = this;
            synchronized (internalFieldDefinition) {
                if (this.flagContainer == null) {
                    this.flagContainer = new XmlFlagContainerSupport(XmlInlineFieldDefinition.this.getXmlField(), (IFieldDefinition)this);
                }
                return this.flagContainer;
            }
        }

        @NonNull
        private Map<String, ? extends IFlagInstance> getFlagInstanceMap() {
            return this.initFlagContainer().getFlagInstanceMap();
        }

        @Nullable
        public IFlagInstance getFlagInstanceByName(String name) {
            return this.getFlagInstanceMap().get(name);
        }

        @NonNull
        public Collection<? extends IFlagInstance> getFlagInstances() {
            return this.getFlagInstanceMap().values();
        }

        public boolean hasJsonKey() {
            return XmlInlineFieldDefinition.this.getXmlField().isSetJsonKey();
        }

        public IFlagInstance getJsonKeyFlagInstance() {
            IFlagInstance retval = null;
            if (this.hasJsonKey()) {
                retval = this.getFlagInstanceByName(XmlInlineFieldDefinition.this.getXmlField().getJsonKey().getFlagRef());
            }
            return retval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        private IValueConstraintSupport initModelConstraints() {
            InternalFieldDefinition internalFieldDefinition = this;
            synchronized (internalFieldDefinition) {
                if (this.constraints == null) {
                    this.constraints = XmlInlineFieldDefinition.this.getXmlField().isSetConstraint() ? new ValueConstraintSupport((DefineFieldConstraintsType)ObjectUtils.notNull((Object)XmlInlineFieldDefinition.this.getXmlField().getConstraint()), IConstraint.ExternalModelSource.instance((URI)((URI)ObjectUtils.requireNonNull((Object)this.getContainingMetaschema().getLocation())))) : new ValueConstraintSupport();
                }
                return this.constraints;
            }
        }

        public List<? extends IConstraint> getConstraints() {
            return this.initModelConstraints().getConstraints();
        }

        public List<? extends IAllowedValuesConstraint> getAllowedValuesConstraints() {
            return this.initModelConstraints().getAllowedValuesConstraints();
        }

        public List<? extends IMatchesConstraint> getMatchesConstraints() {
            return this.initModelConstraints().getMatchesConstraints();
        }

        public List<? extends IIndexHasKeyConstraint> getIndexHasKeyConstraints() {
            return this.initModelConstraints().getIndexHasKeyConstraints();
        }

        public List<? extends IExpectConstraint> getExpectConstraints() {
            return this.initModelConstraints().getExpectConstraints();
        }

        public void addConstraint(@NonNull IAllowedValuesConstraint constraint) {
            this.initModelConstraints().addConstraint(constraint);
        }

        public void addConstraint(@NonNull IMatchesConstraint constraint) {
            this.initModelConstraints().addConstraint(constraint);
        }

        public void addConstraint(@NonNull IIndexHasKeyConstraint constraint) {
            this.initModelConstraints().addConstraint(constraint);
        }

        public void addConstraint(@NonNull IExpectConstraint constraint) {
            this.initModelConstraints().addConstraint(constraint);
        }

        public MarkupMultiline getRemarks() {
            return XmlInlineFieldDefinition.this.getRemarks();
        }

        public IMetaschema getContainingMetaschema() {
            return XmlInlineFieldDefinition.super.getContainingDefinition().getContainingMetaschema();
        }

        public Object getFieldValue(@NonNull Object parentFieldValue) {
            return null;
        }
    }
}

