/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.model.MarkupStringConverter;
import gov.nist.secauto.metaschema.model.ModelFactory;
import gov.nist.secauto.metaschema.model.ValueConstraintSupport;
import gov.nist.secauto.metaschema.model.common.AbstractFlagInstance;
import gov.nist.secauto.metaschema.model.common.IFlagContainer;
import gov.nist.secauto.metaschema.model.common.IFlagDefinition;
import gov.nist.secauto.metaschema.model.common.IInlineDefinition;
import gov.nist.secauto.metaschema.model.common.IMetaschema;
import gov.nist.secauto.metaschema.model.common.ModuleScopeEnum;
import gov.nist.secauto.metaschema.model.common.constraint.IAllowedValuesConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IExpectConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IIndexHasKeyConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IMatchesConstraint;
import gov.nist.secauto.metaschema.model.common.constraint.IValueConstraintSupport;
import gov.nist.secauto.metaschema.model.common.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.model.common.datatype.adapter.MetaschemaDataTypeProvider;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.model.common.util.CollectionUtil;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.model.xmlbeans.DefineFlagConstraintsType;
import gov.nist.secauto.metaschema.model.xmlbeans.InlineFlagDefinitionType;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

class XmlInlineFlagDefinition
extends AbstractFlagInstance {
    @NonNull
    private final InlineFlagDefinitionType xmlFlag;
    @NonNull
    private final InternalFlagDefinition flagDefinition;
    private IValueConstraintSupport constraints;

    public XmlInlineFlagDefinition(@NonNull InlineFlagDefinitionType xmlFlag, @NonNull IFlagContainer parent) {
        super(parent);
        this.xmlFlag = xmlFlag;
        this.flagDefinition = new InternalFlagDefinition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkModelConstraints() {
        XmlInlineFlagDefinition xmlInlineFlagDefinition = this;
        synchronized (xmlInlineFlagDefinition) {
            if (this.constraints == null) {
                this.constraints = this.getXmlFlag().isSetConstraint() ? new ValueConstraintSupport((DefineFlagConstraintsType)ObjectUtils.notNull((Object)this.getXmlFlag().getConstraint()), IConstraint.ExternalModelSource.instance((URI)((URI)ObjectUtils.requireNonNull((Object)this.getContainingMetaschema().getLocation())))) : new ValueConstraintSupport();
            }
        }
    }

    protected final InlineFlagDefinitionType getXmlFlag() {
        return this.xmlFlag;
    }

    public InternalFlagDefinition getDefinition() {
        return this.flagDefinition;
    }

    public IMetaschema getContainingMetaschema() {
        return this.getContainingDefinition().getContainingMetaschema();
    }

    public String getFormalName() {
        return this.getXmlFlag().isSetFormalName() ? this.getXmlFlag().getFormalName() : null;
    }

    public MarkupLine getDescription() {
        return this.getXmlFlag().isSetDescription() ? MarkupStringConverter.toMarkupString(this.getXmlFlag().getDescription()) : null;
    }

    public Map<QName, Set<String>> getProperties() {
        return ModelFactory.toProperties(CollectionUtil.listOrEmpty(this.getXmlFlag().getPropList()));
    }

    public String getName() {
        return this.getXmlFlag().getName();
    }

    public String getUseName() {
        return null;
    }

    public String getXmlNamespace() {
        return null;
    }

    public boolean isRequired() {
        return this.getXmlFlag().isSetRequired() ? this.getXmlFlag().getRequired() : false;
    }

    public MarkupMultiline getRemarks() {
        return this.getXmlFlag().isSetRemarks() ? MarkupStringConverter.toMarkupString(this.getXmlFlag().getRemarks()) : null;
    }

    public Object getValue(@NonNull Object parentValue) {
        return null;
    }

    private final class InternalFlagDefinition
    implements IFlagDefinition,
    IInlineDefinition<XmlInlineFlagDefinition> {
        @Nullable
        private final Object defaultValue;

        private InternalFlagDefinition() {
            Object defaultValue = null;
            if (XmlInlineFlagDefinition.this.getXmlFlag().isSetDefault()) {
                defaultValue = this.getJavaTypeAdapter().parse((String)ObjectUtils.requireNonNull((Object)XmlInlineFlagDefinition.this.getXmlFlag().getDefault()));
            }
            this.defaultValue = defaultValue;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public boolean isInline() {
            return true;
        }

        public XmlInlineFlagDefinition getInlineInstance() {
            return XmlInlineFlagDefinition.this;
        }

        public String getName() {
            return XmlInlineFlagDefinition.this.getName();
        }

        public String getUseName() {
            return null;
        }

        public ModuleScopeEnum getModuleScope() {
            return ModuleScopeEnum.LOCAL;
        }

        public String getFormalName() {
            return XmlInlineFlagDefinition.this.getFormalName();
        }

        public MarkupLine getDescription() {
            return XmlInlineFlagDefinition.this.getDescription();
        }

        public Map<QName, Set<String>> getProperties() {
            return XmlInlineFlagDefinition.this.getProperties();
        }

        public IDataTypeAdapter<?> getJavaTypeAdapter() {
            return XmlInlineFlagDefinition.this.getXmlFlag().isSetAsType() ? XmlInlineFlagDefinition.this.getXmlFlag().getAsType() : MetaschemaDataTypeProvider.DEFAULT_DATA_TYPE;
        }

        public List<? extends IConstraint> getConstraints() {
            XmlInlineFlagDefinition.this.checkModelConstraints();
            return XmlInlineFlagDefinition.this.constraints.getConstraints();
        }

        public List<? extends IAllowedValuesConstraint> getAllowedValuesConstraints() {
            XmlInlineFlagDefinition.this.checkModelConstraints();
            return XmlInlineFlagDefinition.this.constraints.getAllowedValuesConstraints();
        }

        public List<? extends IMatchesConstraint> getMatchesConstraints() {
            XmlInlineFlagDefinition.this.checkModelConstraints();
            return XmlInlineFlagDefinition.this.constraints.getMatchesConstraints();
        }

        public List<? extends IIndexHasKeyConstraint> getIndexHasKeyConstraints() {
            XmlInlineFlagDefinition.this.checkModelConstraints();
            return XmlInlineFlagDefinition.this.constraints.getIndexHasKeyConstraints();
        }

        public List<? extends IExpectConstraint> getExpectConstraints() {
            XmlInlineFlagDefinition.this.checkModelConstraints();
            return XmlInlineFlagDefinition.this.constraints.getExpectConstraints();
        }

        public void addConstraint(@NonNull IAllowedValuesConstraint constraint) {
            XmlInlineFlagDefinition.this.checkModelConstraints();
            XmlInlineFlagDefinition.this.constraints.addConstraint(constraint);
        }

        public void addConstraint(@NonNull IMatchesConstraint constraint) {
            XmlInlineFlagDefinition.this.checkModelConstraints();
            XmlInlineFlagDefinition.this.constraints.addConstraint(constraint);
        }

        public void addConstraint(@NonNull IIndexHasKeyConstraint constraint) {
            XmlInlineFlagDefinition.this.checkModelConstraints();
            XmlInlineFlagDefinition.this.constraints.addConstraint(constraint);
        }

        public void addConstraint(@NonNull IExpectConstraint constraint) {
            XmlInlineFlagDefinition.this.checkModelConstraints();
            XmlInlineFlagDefinition.this.constraints.addConstraint(constraint);
        }

        public MarkupMultiline getRemarks() {
            return XmlInlineFlagDefinition.this.getRemarks();
        }

        public IMetaschema getContainingMetaschema() {
            return XmlInlineFlagDefinition.super.getContainingDefinition().getContainingMetaschema();
        }
    }
}

