/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.model.MarkupStringConverter;
import gov.nist.secauto.metaschema.model.XmlGlobalAssemblyDefinition;
import gov.nist.secauto.metaschema.model.XmlGlobalFieldDefinition;
import gov.nist.secauto.metaschema.model.XmlGlobalFlagDefinition;
import gov.nist.secauto.metaschema.model.common.AbstractMetaschema;
import gov.nist.secauto.metaschema.model.common.IAssemblyDefinition;
import gov.nist.secauto.metaschema.model.common.IFieldDefinition;
import gov.nist.secauto.metaschema.model.common.IFlagContainer;
import gov.nist.secauto.metaschema.model.common.IFlagDefinition;
import gov.nist.secauto.metaschema.model.common.IMetaschema;
import gov.nist.secauto.metaschema.model.common.MetaschemaException;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.model.xmlbeans.GlobalAssemblyDefinitionType;
import gov.nist.secauto.metaschema.model.xmlbeans.GlobalFieldDefinitionType;
import gov.nist.secauto.metaschema.model.xmlbeans.GlobalFlagDefinitionType;
import gov.nist.secauto.metaschema.model.xmlbeans.METASCHEMADocument;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.XmlCursor;

class XmlMetaschema
extends AbstractMetaschema {
    private static final Logger LOGGER = LogManager.getLogger(XmlMetaschema.class);
    @NonNull
    private final URI location;
    @NonNull
    private final METASCHEMADocument metaschema;
    private final Map<String, ? extends IFlagDefinition> flagDefinitions;
    private final Map<String, ? extends IFieldDefinition> fieldDefinitions;
    private final Map<String, ? extends IAssemblyDefinition> assemblyDefinitions;
    private final Map<String, ? extends IAssemblyDefinition> rootAssemblyDefinitions;

    XmlMetaschema(@NonNull URI resource, @NonNull METASCHEMADocument metaschemaXml, @NonNull List<IMetaschema> importedMetaschema) throws MetaschemaException {
        super(importedMetaschema);
        Object obj;
        this.location = (URI)ObjectUtils.requireNonNull((Object)resource, (String)"resource");
        Objects.requireNonNull(metaschemaXml.getMETASCHEMA());
        this.metaschema = metaschemaXml;
        METASCHEMADocument.METASCHEMA metaschemaNode = this.metaschema.getMETASCHEMA();
        try (XmlCursor cursor = metaschemaNode.newCursor();){
            cursor.selectPath("declare namespace m='http://csrc.nist.gov/ns/oscal/metaschema/1.0';$this/m:define-flag");
            LinkedHashMap<String, XmlGlobalFlagDefinition> flagDefinitions = new LinkedHashMap<String, XmlGlobalFlagDefinition>();
            while (cursor.toNextSelection()) {
                obj = (GlobalFlagDefinitionType)ObjectUtils.notNull((Object)((GlobalFlagDefinitionType)cursor.getObject()));
                XmlGlobalFlagDefinition flag = new XmlGlobalFlagDefinition((GlobalFlagDefinitionType)obj, (IMetaschema)this);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("New flag definition '{}'", (Object)flag.toCoordinates());
                }
                flagDefinitions.put(flag.getName(), flag);
            }
            this.flagDefinitions = flagDefinitions.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(flagDefinitions);
        }
        cursor = metaschemaNode.newCursor();
        try {
            cursor.selectPath("declare namespace m='http://csrc.nist.gov/ns/oscal/metaschema/1.0';$this/m:define-field");
            LinkedHashMap<String, XmlGlobalFieldDefinition> fieldDefinitions = new LinkedHashMap<String, XmlGlobalFieldDefinition>();
            while (cursor.toNextSelection()) {
                obj = (GlobalFieldDefinitionType)ObjectUtils.notNull((Object)((GlobalFieldDefinitionType)cursor.getObject()));
                XmlGlobalFieldDefinition field = new XmlGlobalFieldDefinition((GlobalFieldDefinitionType)obj, (IMetaschema)this);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("New field definition '{}'", (Object)field.toCoordinates());
                }
                fieldDefinitions.put(field.getName(), field);
            }
            this.fieldDefinitions = fieldDefinitions.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(fieldDefinitions);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        LinkedHashMap<String, XmlGlobalAssemblyDefinition> assemblyDefinitions = new LinkedHashMap<String, XmlGlobalAssemblyDefinition>();
        LinkedHashMap<String, XmlGlobalAssemblyDefinition> rootAssemblyDefinitions = new LinkedHashMap<String, XmlGlobalAssemblyDefinition>();
        try (XmlCursor cursor = metaschemaNode.newCursor();){
            cursor.selectPath("declare namespace m='http://csrc.nist.gov/ns/oscal/metaschema/1.0';$this/m:define-assembly");
            while (cursor.toNextSelection()) {
                GlobalAssemblyDefinitionType obj2 = (GlobalAssemblyDefinitionType)ObjectUtils.notNull((Object)((GlobalAssemblyDefinitionType)cursor.getObject()));
                XmlGlobalAssemblyDefinition assembly = new XmlGlobalAssemblyDefinition(obj2, this);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("New assembly definition '{}'", (Object)assembly.toCoordinates());
                }
                assemblyDefinitions.put(assembly.getName(), assembly);
                if (!assembly.isRoot()) continue;
                rootAssemblyDefinitions.put((String)ObjectUtils.notNull((Object)assembly.getRootName()), assembly);
            }
            this.assemblyDefinitions = assemblyDefinitions.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(assemblyDefinitions);
            this.rootAssemblyDefinitions = rootAssemblyDefinitions.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(rootAssemblyDefinitions);
        }
    }

    @NonNull
    public URI getLocation() {
        return this.location;
    }

    @NonNull
    protected METASCHEMADocument.METASCHEMA getXmlMetaschema() {
        return (METASCHEMADocument.METASCHEMA)ObjectUtils.notNull((Object)this.metaschema.getMETASCHEMA());
    }

    public MarkupLine getName() {
        return MarkupStringConverter.toMarkupString(this.getXmlMetaschema().getSchemaName());
    }

    public String getVersion() {
        return this.getXmlMetaschema().getSchemaVersion();
    }

    public MarkupMultiline getRemarks() {
        return this.getXmlMetaschema().isSetRemarks() ? MarkupStringConverter.toMarkupString(this.getXmlMetaschema().getRemarks()) : null;
    }

    public String getShortName() {
        return this.getXmlMetaschema().getShortName();
    }

    public URI getXmlNamespace() {
        return URI.create(this.getXmlMetaschema().getNamespace());
    }

    public URI getJsonBaseUri() {
        return URI.create(this.getXmlMetaschema().getJsonBaseUri());
    }

    private Map<String, ? extends IAssemblyDefinition> getAssemblyDefinitionMap() {
        return this.assemblyDefinitions;
    }

    public Collection<? extends IAssemblyDefinition> getAssemblyDefinitions() {
        return this.getAssemblyDefinitionMap().values();
    }

    public IAssemblyDefinition getAssemblyDefinitionByName(@NonNull String name) {
        return this.getAssemblyDefinitionMap().get(name);
    }

    private Map<String, ? extends IFieldDefinition> getFieldDefinitionMap() {
        return this.fieldDefinitions;
    }

    public Collection<? extends IFieldDefinition> getFieldDefinitions() {
        return this.getFieldDefinitionMap().values();
    }

    public IFieldDefinition getFieldDefinitionByName(@NonNull String name) {
        return this.getFieldDefinitionMap().get(name);
    }

    public List<? extends IFlagContainer> getAssemblyAndFieldDefinitions() {
        return Stream.concat(this.getAssemblyDefinitions().stream(), this.getFieldDefinitions().stream()).collect(Collectors.toList());
    }

    private Map<String, ? extends IFlagDefinition> getFlagDefinitionMap() {
        return this.flagDefinitions;
    }

    public Collection<? extends IFlagDefinition> getFlagDefinitions() {
        return this.getFlagDefinitionMap().values();
    }

    public IFlagDefinition getFlagDefinitionByName(@NonNull String name) {
        return this.getFlagDefinitionMap().get(name);
    }

    private Map<String, ? extends IAssemblyDefinition> getRootAssemblyDefinitionMap() {
        return this.rootAssemblyDefinitions;
    }

    public Collection<? extends IAssemblyDefinition> getRootAssemblyDefinitions() {
        return this.getRootAssemblyDefinitionMap().values();
    }
}

