/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.model.XmlModelParser;
import gov.nist.secauto.metaschema.model.common.IAssemblyInstance;
import gov.nist.secauto.metaschema.model.common.IChoiceInstance;
import gov.nist.secauto.metaschema.model.common.IFieldInstance;
import gov.nist.secauto.metaschema.model.common.IModelContainer;
import gov.nist.secauto.metaschema.model.common.IModelInstance;
import gov.nist.secauto.metaschema.model.common.INamedModelInstance;
import gov.nist.secauto.metaschema.model.xmlbeans.ChoiceType;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.xmlbeans.XmlObject;

class XmlModelContainerSupport {
    @NonNull
    private final List<? extends IModelInstance> modelInstances;
    @NonNull
    private final Map<String, ? extends INamedModelInstance> namedModelInstances;
    @NonNull
    private final Map<String, ? extends IFieldInstance> fieldInstances;
    @NonNull
    private final Map<String, ? extends IAssemblyInstance> assemblyInstances;

    public XmlModelContainerSupport(@NonNull XmlObject xmlContent, @NonNull IModelContainer container) {
        XmlModelParser parser = new XmlModelParser();
        if (xmlContent instanceof ChoiceType) {
            parser.parseChoice(xmlContent, container);
        } else {
            parser.parseModel(xmlContent, container);
        }
        this.modelInstances = parser.getModelInstances();
        this.namedModelInstances = parser.getNamedModelInstances();
        this.fieldInstances = parser.getFieldInstances();
        this.assemblyInstances = parser.getAssemblyInstances();
    }

    @NonNull
    public List<? extends IModelInstance> getModelInstances() {
        return this.modelInstances;
    }

    @NonNull
    public Map<String, ? extends INamedModelInstance> getNamedModelInstanceMap() {
        return this.namedModelInstances;
    }

    @NonNull
    public Map<String, ? extends IFieldInstance> getFieldInstanceMap() {
        return this.fieldInstances;
    }

    @NonNull
    public Map<String, ? extends IAssemblyInstance> getAssemblyInstanceMap() {
        return this.assemblyInstances;
    }

    @NonNull
    public List<? extends IChoiceInstance> getChoiceInstances() {
        return this.getModelInstances().stream().filter(obj -> obj instanceof IChoiceInstance).map(obj -> (IChoiceInstance)obj).collect(Collectors.toList());
    }
}

