/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.model.XmlAssemblyInstance;
import gov.nist.secauto.metaschema.model.XmlChoiceInstance;
import gov.nist.secauto.metaschema.model.XmlFieldInstance;
import gov.nist.secauto.metaschema.model.XmlInlineAssemblyDefinition;
import gov.nist.secauto.metaschema.model.XmlInlineFieldDefinition;
import gov.nist.secauto.metaschema.model.common.AbstractAssemblyInstance;
import gov.nist.secauto.metaschema.model.common.AbstractFieldInstance;
import gov.nist.secauto.metaschema.model.common.IAssemblyInstance;
import gov.nist.secauto.metaschema.model.common.IFieldInstance;
import gov.nist.secauto.metaschema.model.common.IModelContainer;
import gov.nist.secauto.metaschema.model.common.IModelInstance;
import gov.nist.secauto.metaschema.model.common.INamedInstance;
import gov.nist.secauto.metaschema.model.common.INamedModelInstance;
import gov.nist.secauto.metaschema.model.common.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.model.common.MetaschemaModelConstants;
import gov.nist.secauto.metaschema.model.common.XmlGroupAsBehavior;
import gov.nist.secauto.metaschema.model.common.util.CustomCollectors;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.model.xmlbeans.AssemblyReferenceType;
import gov.nist.secauto.metaschema.model.xmlbeans.ChoiceType;
import gov.nist.secauto.metaschema.model.xmlbeans.FieldReferenceType;
import gov.nist.secauto.metaschema.model.xmlbeans.GroupAsType;
import gov.nist.secauto.metaschema.model.xmlbeans.InlineAssemblyDefinitionType;
import gov.nist.secauto.metaschema.model.xmlbeans.InlineFieldDefinitionType;
import java.math.BigInteger;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;

class XmlModelParser {
    private Map<String, INamedModelInstance> namedModelInstances;
    private Map<String, IFieldInstance> fieldInstances;
    private Map<String, IAssemblyInstance> assemblyInstances;
    private List<? extends IModelInstance> modelInstances;

    XmlModelParser() {
    }

    void parseChoice(XmlObject xmlObject, @NonNull IModelContainer container) {
        try (XmlCursor cursor = xmlObject.newCursor();){
            cursor.selectPath("declare namespace m='http://csrc.nist.gov/ns/oscal/metaschema/1.0';$this/m:assembly|$this/m:define-assembly|$this/m:field|$this/m:define-field");
            this.parseInternal(cursor, container);
        }
    }

    void parseModel(XmlObject xmlObject, @NonNull IModelContainer container) {
        try (XmlCursor cursor = xmlObject.newCursor();){
            cursor.selectPath("declare namespace m='http://csrc.nist.gov/ns/oscal/metaschema/1.0';$this/m:model/m:assembly|$this/m:model/m:define-assembly|$this/m:model/m:field|$this/m:model/m:define-field|$this/m:model/m:choice");
            this.parseInternal(cursor, container);
        }
    }

    @NonNull
    protected <S> Stream<S> append(@NonNull Stream<S> original, @NonNull S item) {
        Stream newStream = (Stream)Stream.of(item).sequential();
        return Stream.concat(original, newStream);
    }

    private void parseInternal(XmlCursor cursor, @NonNull IModelContainer container) {
        Stream<XmlFieldInstance> fieldInstances = Stream.empty();
        fieldInstances = (Stream<XmlFieldInstance>)fieldInstances.sequential();
        Stream<XmlAssemblyInstance> assemblyInstances = Stream.empty();
        assemblyInstances = (Stream<XmlAssemblyInstance>)assemblyInstances.sequential();
        Stream<AbstractFieldInstance> namedModelInstances = Stream.empty();
        namedModelInstances = (Stream<AbstractFieldInstance>)namedModelInstances.sequential();
        Stream<Object> modelInstances = Stream.empty();
        modelInstances = (Stream<AbstractFieldInstance>)modelInstances.sequential();
        while (cursor.toNextSelection()) {
            AbstractAssemblyInstance assembly;
            AbstractFieldInstance field;
            XmlObject obj = cursor.getObject();
            if (obj instanceof FieldReferenceType) {
                field = new XmlFieldInstance((FieldReferenceType)obj, container);
                fieldInstances = this.append(fieldInstances, field);
                namedModelInstances = this.append(namedModelInstances, field);
                modelInstances = this.append(modelInstances, field);
                continue;
            }
            if (obj instanceof InlineFieldDefinitionType) {
                field = new XmlInlineFieldDefinition((InlineFieldDefinitionType)obj, container);
                fieldInstances = this.append(fieldInstances, field);
                namedModelInstances = this.append(namedModelInstances, field);
                modelInstances = this.append(modelInstances, field);
                continue;
            }
            if (obj instanceof AssemblyReferenceType) {
                assembly = new XmlAssemblyInstance((AssemblyReferenceType)obj, container);
                assemblyInstances = this.append(assemblyInstances, assembly);
                namedModelInstances = this.append(namedModelInstances, assembly);
                modelInstances = this.append(modelInstances, assembly);
                continue;
            }
            if (obj instanceof InlineAssemblyDefinitionType) {
                assembly = new XmlInlineAssemblyDefinition((InlineAssemblyDefinitionType)obj, container);
                assemblyInstances = this.append(assemblyInstances, assembly);
                namedModelInstances = this.append(namedModelInstances, assembly);
                modelInstances = this.append(modelInstances, assembly);
                continue;
            }
            if (!(obj instanceof ChoiceType)) continue;
            XmlChoiceInstance choice = new XmlChoiceInstance((ChoiceType)obj, container);
            modelInstances = this.append(modelInstances, choice);
        }
        this.fieldInstances = fieldInstances.collect(Collectors.toMap(INamedInstance::getEffectiveName, Function.identity(), CustomCollectors.useFirstMapper(), LinkedHashMap::new));
        this.assemblyInstances = assemblyInstances.collect(Collectors.toMap(INamedInstance::getEffectiveName, Function.identity(), CustomCollectors.useFirstMapper(), LinkedHashMap::new));
        this.modelInstances = modelInstances.collect(Collectors.toUnmodifiableList());
        this.namedModelInstances = namedModelInstances.collect(Collectors.toMap(INamedInstance::getEffectiveName, Function.identity(), CustomCollectors.useFirstMapper(), LinkedHashMap::new));
    }

    @NonNull
    public Map<String, ? extends IFieldInstance> getFieldInstances() {
        return this.fieldInstances == null ? Collections.emptyMap() : this.fieldInstances;
    }

    @NonNull
    public Map<String, ? extends IAssemblyInstance> getAssemblyInstances() {
        return this.assemblyInstances == null ? Collections.emptyMap() : this.assemblyInstances;
    }

    @NonNull
    public Map<String, ? extends INamedModelInstance> getNamedModelInstances() {
        return this.namedModelInstances == null ? Collections.emptyMap() : this.namedModelInstances;
    }

    @NonNull
    protected List<? extends IModelInstance> getModelInstances() {
        return this.modelInstances == null ? Collections.emptyList() : this.modelInstances;
    }

    @NonNull
    public static JsonGroupAsBehavior getJsonGroupAsBehavior(@Nullable GroupAsType groupAs) {
        JsonGroupAsBehavior retval = MetaschemaModelConstants.DEFAULT_JSON_GROUP_AS_BEHAVIOR;
        if (groupAs != null && groupAs.isSetInJson()) {
            retval = (JsonGroupAsBehavior)ObjectUtils.notNull((Object)groupAs.getInJson());
        }
        return retval;
    }

    @NonNull
    public static XmlGroupAsBehavior getXmlGroupAsBehavior(@Nullable GroupAsType groupAs) {
        XmlGroupAsBehavior retval = MetaschemaModelConstants.DEFAULT_XML_GROUP_AS_BEHAVIOR;
        if (groupAs != null && groupAs.isSetInXml()) {
            retval = (XmlGroupAsBehavior)ObjectUtils.notNull((Object)groupAs.getInXml());
        }
        return retval;
    }

    public static int getMinOccurs(@Nullable BigInteger value) {
        int retval = 0;
        if (value != null) {
            retval = value.intValueExact();
        }
        return retval;
    }

    public static int getMaxOccurs(@Nullable Object value) {
        int retval = 1;
        if (value != null) {
            if (value instanceof String) {
                retval = -1;
            } else if (value instanceof BigInteger) {
                retval = ((BigInteger)value).intValueExact();
            } else {
                throw new IllegalStateException("Invalid type: " + value.getClass().getName());
            }
        }
        return retval;
    }
}

