/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.model;

import com.vladsch.flexmark.parser.ListOptions;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.model.common.datatype.markup.IMarkupString;
import gov.nist.secauto.metaschema.model.common.datatype.markup.flexmark.AbstractMarkupWriter;
import gov.nist.secauto.metaschema.model.common.datatype.markup.flexmark.IMarkupWriter;
import gov.nist.secauto.metaschema.model.common.datatype.markup.flexmark.MarkupVisitor;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;

class XmlbeansMarkupVisitor
extends AbstractMarkupWriter<XmlCursor, IllegalArgumentException> {
    public static void visit(@NonNull IMarkupString<?> markup, @NonNull String namespace, @NonNull XmlObject obj) {
        try (XmlCursor cursor = (XmlCursor)ObjectUtils.notNull((Object)obj.newCursor());){
            XmlbeansMarkupVisitor.visit(markup, namespace, cursor);
        }
    }

    public static void visit(@NonNull IMarkupString<?> markup, @NonNull String namespace, @NonNull XmlCursor cursor) {
        XmlbeansMarkupVisitor writer = new XmlbeansMarkupVisitor(namespace, markup.getFlexmarkFactory().getListOptions(), cursor);
        MarkupVisitor visitor = new MarkupVisitor(markup.isBlock());
        visitor.visitDocument(markup.getDocument(), (IMarkupWriter)writer);
    }

    protected XmlbeansMarkupVisitor(@NonNull String namespace, @NonNull ListOptions options, @NonNull XmlCursor writer) {
        super(namespace, options, (Object)writer);
    }

    public void writeEmptyElement(QName qname, Map<String, String> attributes) throws IllegalArgumentException {
        XmlCursor cursor = (XmlCursor)this.getStream();
        cursor.beginElement(qname);
        attributes.forEach((name, value) -> cursor.insertAttributeWithValue(name, value));
        cursor.toEndToken();
        cursor.toNextToken();
    }

    public void writeElementStart(QName qname, Map<String, String> attributes) throws IllegalArgumentException {
        XmlCursor cursor = (XmlCursor)this.getStream();
        cursor.beginElement(qname);
        attributes.forEach((name, value) -> cursor.insertAttributeWithValue(name, value));
        cursor.push();
    }

    public void writeElementEnd(QName qname) throws IllegalArgumentException {
        XmlCursor cursor = (XmlCursor)this.getStream();
        cursor.pop();
        cursor.toEndToken();
        cursor.toNextToken();
    }

    public void writeText(CharSequence text) throws IllegalArgumentException {
        XmlCursor cursor = (XmlCursor)this.getStream();
        cursor.insertChars(text.toString());
    }

    protected void writeComment(CharSequence text) throws IllegalArgumentException {
        XmlCursor cursor = (XmlCursor)this.getStream();
        cursor.insertComment(text.toString());
    }
}

