/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.model.xmlbeans.handler;

import gov.nist.secauto.metaschema.model.common.metapath.MetapathException;
import gov.nist.secauto.metaschema.model.common.metapath.MetapathExpression;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import org.apache.xmlbeans.SimpleValue;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlLineNumber;
import org.apache.xmlbeans.impl.values.XmlValueNotSupportedException;

public final class MetapathExpressionHandler {
    private MetapathExpressionHandler() {
    }

    public static MetapathExpression decodeMetaschemaPathType(SimpleValue value) {
        String path = (String)ObjectUtils.notNull((Object)value.getStringValue());
        try {
            return MetapathExpression.compile((String)path);
        }
        catch (MetapathException ex) {
            StringBuilder builder = new StringBuilder(48).append("Error parsing metapath '").append(value).append('\'');
            try (XmlCursor cursor = value.newCursor();){
                cursor.toParent();
                XmlCursor.XmlBookmark bookmark = cursor.getBookmark(XmlLineNumber.class);
                if (bookmark != null) {
                    XmlLineNumber lineNumber = (XmlLineNumber)bookmark;
                    builder.append(" at location ").append(lineNumber.getLine()).append(':').append(lineNumber.getColumn());
                }
            }
            XmlValueNotSupportedException exNew = new XmlValueNotSupportedException(builder.toString());
            exNew.initCause((Throwable)ex);
            throw exNew;
        }
    }

    public static void encodeMetaschemaPathType(MetapathExpression expression, SimpleValue target) {
        if (expression != null) {
            target.setStringValue(expression.getPath());
        }
    }
}

