/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.model.common.IDefinition;
import gov.nist.secauto.metaschema.model.common.IMetaschema;
import gov.nist.secauto.metaschema.model.common.INamedInstance;
import gov.nist.secauto.metaschema.model.common.IValuedDefinition;
import gov.nist.secauto.metaschema.model.common.configuration.IConfiguration;
import gov.nist.secauto.metaschema.model.common.constraint.IAllowedValue;
import gov.nist.secauto.metaschema.model.common.constraint.IAllowedValuesConstraint;
import gov.nist.secauto.metaschema.model.common.metapath.MetapathExpression;
import gov.nist.secauto.metaschema.model.common.util.CollectionUtil;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.IGenerationState;
import gov.nist.secauto.metaschema.schemagen.IInlineStrategy;
import gov.nist.secauto.metaschema.schemagen.MetaschemaIndex;
import gov.nist.secauto.metaschema.schemagen.SchemaGenerationFeature;
import gov.nist.secauto.metaschema.schemagen.datatype.IDatatypeManager;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public abstract class AbstractGenerationState<WRITER, DATATYPE_MANAGER extends IDatatypeManager>
implements IGenerationState<WRITER> {
    @NonNull
    private final IMetaschema metaschema;
    @NonNull
    private final WRITER writer;
    @NonNull
    private final DATATYPE_MANAGER datatypeManager;
    @NonNull
    private final IInlineStrategy inlineStrategy;
    @NonNull
    private final MetaschemaIndex metaschemaIndex;

    public AbstractGenerationState(@NonNull IMetaschema metaschema, @NonNull WRITER writer, @NonNull IConfiguration<SchemaGenerationFeature<?>> configuration, @NonNull DATATYPE_MANAGER datatypeManager) {
        this.metaschema = metaschema;
        this.writer = writer;
        this.datatypeManager = datatypeManager;
        this.inlineStrategy = IInlineStrategy.newInlineStrategy(configuration);
        this.metaschemaIndex = MetaschemaIndex.indexDefinitions(metaschema);
    }

    @Override
    public IMetaschema getMetaschema() {
        return this.metaschema;
    }

    @Override
    public WRITER getWriter() {
        return this.writer;
    }

    @NonNull
    protected DATATYPE_MANAGER getDatatypeManager() {
        return this.datatypeManager;
    }

    @NonNull
    public MetaschemaIndex getMetaschemaIndex() {
        return this.metaschemaIndex;
    }

    @Override
    public boolean isInline(@NonNull IDefinition definition) {
        return this.inlineStrategy.isInline(definition, this.getMetaschemaIndex());
    }

    @NonNull
    protected static AllowedValueCollection getContextIndependentEnumeratedValues(@NonNull IValuedDefinition definition) {
        List<Object> values = new LinkedList<IAllowedValue>();
        boolean closed = false;
        for (IAllowedValuesConstraint constraint : definition.getAllowedValuesConstraints()) {
            if (!constraint.isAllowedOther()) {
                closed = true;
            }
            if (!MetapathExpression.CONTEXT_NODE.equals(constraint.getTarget())) {
                values = CollectionUtil.emptyList();
                break;
            }
            values.addAll(constraint.getAllowedValues().values());
        }
        return new AllowedValueCollection(closed, values);
    }

    private CharSequence getTypeContext(@NonNull IDefinition definition, @NonNull IMetaschema childMetaschema) {
        StringBuilder builder = new StringBuilder();
        if (definition.isInline()) {
            INamedInstance inlineInstance = definition.getInlineInstance();
            IDefinition parentDefinition = inlineInstance.getContainingDefinition();
            builder.append(this.getTypeContext(parentDefinition, childMetaschema)).append(AbstractGenerationState.toCamelCase(inlineInstance.getEffectiveName()));
        } else {
            builder.append(AbstractGenerationState.toCamelCase(definition.getEffectiveName()));
        }
        return builder;
    }

    @NonNull
    public String getTypeNameForDefinition(@NonNull IDefinition definition, @Nullable String suffix) {
        StringBuilder builder = new StringBuilder().append(AbstractGenerationState.toCamelCase(definition.getModelType().name())).append(AbstractGenerationState.toCamelCase(definition.getContainingMetaschema().getShortName()));
        if (this.isInline(definition)) {
            builder.append(AbstractGenerationState.toCamelCase(definition.getEffectiveName()));
        } else {
            builder.append(this.getTypeContext(definition, definition.getContainingMetaschema()));
        }
        if (suffix != null && !suffix.isBlank()) {
            builder.append(AbstractGenerationState.toCamelCase(suffix));
        }
        builder.append("Type");
        return (String)ObjectUtils.notNull((Object)builder.toString());
    }

    @NonNull
    protected static CharSequence toCamelCase(String text) {
        StringBuilder builder = new StringBuilder();
        for (String segment : text.split("\\p{Punct}")) {
            if (segment.length() > 0) {
                builder.append(segment.substring(0, 1).toUpperCase(Locale.ROOT));
            }
            if (segment.length() <= 1) continue;
            builder.append(segment.substring(1).toLowerCase(Locale.ROOT));
        }
        return builder;
    }

    public static class AllowedValueCollection {
        private final boolean closed;
        @NonNull
        private final List<IAllowedValue> values;

        public AllowedValueCollection(boolean closed, @NonNull List<IAllowedValue> values) {
            this.closed = closed;
            this.values = CollectionUtil.unmodifiableList(new ArrayList<IAllowedValue>(values));
        }

        public boolean isClosed() {
            return this.closed;
        }

        @NonNull
        public List<IAllowedValue> getValues() {
            return this.values;
        }
    }
}

