/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.model.common.IAssemblyDefinition;
import gov.nist.secauto.metaschema.model.common.IDefinition;
import gov.nist.secauto.metaschema.model.common.IMetaschema;
import gov.nist.secauto.metaschema.model.common.IRootAssemblyDefinition;
import gov.nist.secauto.metaschema.model.common.RootAssemblyDefinitionWrapper;
import gov.nist.secauto.metaschema.model.common.configuration.IConfiguration;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.AbstractGenerationState;
import gov.nist.secauto.metaschema.schemagen.ISchemaGenerator;
import gov.nist.secauto.metaschema.schemagen.MetaschemaIndex;
import gov.nist.secauto.metaschema.schemagen.SchemaGenerationException;
import gov.nist.secauto.metaschema.schemagen.SchemaGenerationFeature;
import gov.nist.secauto.metaschema.schemagen.datatype.IDatatypeManager;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;

public abstract class AbstractSchemaGenerator<T extends AutoCloseable, D extends IDatatypeManager, S extends AbstractGenerationState<T, D>>
implements ISchemaGenerator {
    @NonNull
    protected abstract T newWriter(@NonNull Writer var1);

    @NonNull
    protected abstract S newGenerationState(@NonNull IMetaschema var1, @NonNull T var2, @NonNull IConfiguration<SchemaGenerationFeature<?>> var3);

    protected abstract void generateSchema(@NonNull S var1);

    @Override
    public void generateFromMetaschema(IMetaschema metaschema, Writer out, IConfiguration<SchemaGenerationFeature<?>> configuration) {
        try {
            T schemaWriter = this.newWriter(out);
            S generationState = this.newGenerationState(metaschema, schemaWriter, configuration);
            this.generateSchema(generationState);
            generationState.flushWriter();
        }
        catch (SchemaGenerationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SchemaGenerationException(ex);
        }
    }

    protected List<IRootAssemblyDefinition> analyzeDefinitions(@NonNull S generationState, @Nullable BiConsumer<MetaschemaIndex.DefinitionEntry, IDefinition> handler) {
        LinkedList<IRootAssemblyDefinition> rootAssemblyDefinitions = new LinkedList<IRootAssemblyDefinition>();
        for (MetaschemaIndex.DefinitionEntry entry : ((AbstractGenerationState)generationState).getMetaschemaIndex().getDefinitions()) {
            boolean referenced = entry.isReferenced();
            IDefinition definition = (IDefinition)ObjectUtils.notNull((Object)entry.getDefinition());
            if (definition instanceof IAssemblyDefinition && ((IAssemblyDefinition)definition).isRoot()) {
                RootAssemblyDefinitionWrapper assemblyDefinition = new RootAssemblyDefinitionWrapper((IAssemblyDefinition)definition);
                rootAssemblyDefinitions.add((IRootAssemblyDefinition)assemblyDefinition);
                if (!referenced) {
                    referenced = true;
                    entry.incrementReferenceCount();
                }
            }
            if (!referenced || handler == null) continue;
            handler.accept(entry, definition);
        }
        return rootAssemblyDefinitions;
    }
}

