/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.model.common.IFlagInstance;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class FlagInstanceFilter {
    private FlagInstanceFilter() {
    }

    @NonNull
    public static Collection<? extends IFlagInstance> filterFlags(@NonNull Collection<? extends IFlagInstance> flags, IFlagInstance jsonKeyFlag) {
        Predicate<IFlagInstance> filter = null;
        if (jsonKeyFlag != null) {
            filter = FlagInstanceFilter.filterFlag(jsonKeyFlag);
        }
        return FlagInstanceFilter.applyFilter(flags, filter);
    }

    @NonNull
    public static Collection<? extends IFlagInstance> filterFlags(@NonNull Collection<? extends IFlagInstance> flags, IFlagInstance jsonKeyFlag, IFlagInstance jsonValueKeyFlag) {
        Predicate<IFlagInstance> filter = null;
        if (jsonKeyFlag != null) {
            filter = FlagInstanceFilter.filterFlag(jsonKeyFlag);
        }
        if (jsonValueKeyFlag != null) {
            Predicate<IFlagInstance> jsonValueKeyFilter = FlagInstanceFilter.filterFlag(jsonValueKeyFlag);
            filter = filter == null ? jsonValueKeyFilter : filter.and(jsonValueKeyFilter);
        }
        return FlagInstanceFilter.applyFilter(flags, filter);
    }

    @NonNull
    private static Predicate<IFlagInstance> filterFlag(@NonNull IFlagInstance flagToFilter) {
        return flag -> flag != flagToFilter;
    }

    @NonNull
    private static Collection<? extends IFlagInstance> applyFilter(@NonNull Collection<? extends IFlagInstance> flags, Predicate<IFlagInstance> filter) {
        Collection retval = filter == null ? flags : (Collection)ObjectUtils.notNull(flags.stream().filter(filter).collect(Collectors.toList()));
        return retval;
    }
}

