/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.model.common.IAssemblyDefinition;
import gov.nist.secauto.metaschema.model.common.IAssemblyInstance;
import gov.nist.secauto.metaschema.model.common.IChoiceInstance;
import gov.nist.secauto.metaschema.model.common.IDefinition;
import gov.nist.secauto.metaschema.model.common.IFieldInstance;
import gov.nist.secauto.metaschema.model.common.IFlagDefinition;
import gov.nist.secauto.metaschema.model.common.IFlagInstance;
import gov.nist.secauto.metaschema.model.common.IMetaschema;
import gov.nist.secauto.metaschema.model.common.INamedInstance;
import gov.nist.secauto.metaschema.model.common.util.ModelWalker;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class MetaschemaIndex {
    private final Map<IDefinition, DefinitionEntry> index = new ConcurrentHashMap<IDefinition, DefinitionEntry>();

    @NonNull
    public static MetaschemaIndex indexDefinitions(@NonNull IMetaschema metaschema) {
        Collection definitions = metaschema.getExportedRootAssemblyDefinitions();
        MetaschemaIndex index = new MetaschemaIndex();
        if (!definitions.isEmpty()) {
            IndexVisitor visitor = new IndexVisitor(index);
            for (IAssemblyDefinition definition : definitions) {
                assert (definition != null);
                index.getEntry((IDefinition)definition).incrementReferenceCount();
                visitor.walk((IAssemblyDefinition)ObjectUtils.requireNonNull((Object)definition));
            }
        }
        return index;
    }

    public boolean hasEntry(@NonNull IDefinition definition) {
        return this.index.containsKey(definition);
    }

    @NonNull
    public DefinitionEntry getEntry(@NonNull IDefinition definition) {
        return (DefinitionEntry)ObjectUtils.notNull((Object)this.index.computeIfAbsent(definition, k -> new DefinitionEntry((IDefinition)ObjectUtils.notNull((Object)k))));
    }

    @NonNull
    public Collection<DefinitionEntry> getDefinitions() {
        return (Collection)ObjectUtils.notNull(this.index.values());
    }

    public static class DefinitionEntry {
        @NonNull
        private final IDefinition definition;
        private final AtomicInteger referenceCount = new AtomicInteger();
        private final AtomicBoolean usedAsChoice = new AtomicBoolean();
        private final AtomicBoolean choiceSibling = new AtomicBoolean();

        public DefinitionEntry(@NonNull IDefinition definition) {
            this.definition = definition;
        }

        public IDefinition getDefinition() {
            return this.definition;
        }

        public boolean isReferenced() {
            return this.getReferenceCount() > 0;
        }

        public int getReferenceCount() {
            return this.referenceCount.get();
        }

        public int incrementReferenceCount() {
            return this.referenceCount.incrementAndGet();
        }

        public int incrementReferenceCount(int increment) {
            return this.referenceCount.addAndGet(increment);
        }

        public boolean isInline() {
            return this.getDefinition().isInline();
        }

        public void markUsedAsChoice() {
            this.usedAsChoice.compareAndSet(false, true);
        }

        public boolean isUsedAsChoice() {
            return this.usedAsChoice.get();
        }

        public void markAsChoiceSibling() {
            this.choiceSibling.compareAndSet(false, true);
        }

        public boolean isChoiceSibling() {
            return this.choiceSibling.get();
        }
    }

    private static class IndexVisitor
    extends ModelWalker<MetaschemaIndex> {
        private final MetaschemaIndex index;

        public IndexVisitor(@NonNull MetaschemaIndex index) {
            this.index = index;
        }

        protected MetaschemaIndex getDefaultData() {
            return this.index;
        }

        protected boolean visit(IFlagInstance instance, MetaschemaIndex data) {
            return this.handleInstance((INamedInstance)instance);
        }

        protected boolean visit(IFieldInstance instance, MetaschemaIndex data) {
            return this.handleInstance((INamedInstance)instance);
        }

        protected boolean visit(IAssemblyInstance instance, MetaschemaIndex data) {
            return this.handleInstance((INamedInstance)instance);
        }

        protected void visit(IFlagDefinition def, MetaschemaIndex data) {
        }

        private boolean handleInstance(INamedInstance instance) {
            IDefinition definition = instance.getDefinition();
            boolean exists = this.getDefaultData().hasEntry(definition);
            DefinitionEntry entry = this.getDefaultData().getEntry(definition);
            entry.incrementReferenceCount();
            if (IndexVisitor.isChoice(instance)) {
                entry.markUsedAsChoice();
            }
            if (IndexVisitor.isChoiceSibling(instance)) {
                entry.markAsChoiceSibling();
            }
            return !exists;
        }

        private static boolean isChoice(@NonNull INamedInstance instance) {
            return instance.getParentContainer() instanceof IChoiceInstance;
        }

        private static boolean isChoiceSibling(@NonNull INamedInstance instance) {
            IDefinition containingDefinition = instance.getContainingDefinition();
            return containingDefinition instanceof IAssemblyDefinition && !((IAssemblyDefinition)containingDefinition).getChoiceInstances().isEmpty();
        }
    }
}

