/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.datatype;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.model.common.util.CollectionUtil;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.datatype.IDatatypeContent;
import gov.nist.secauto.metaschema.schemagen.datatype.IDatatypeProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamWriter2;

public class CompositeDatatypeProvider
implements IDatatypeProvider {
    @NonNull
    private final List<IDatatypeProvider> proxiedProviders;

    public CompositeDatatypeProvider(@NonNull List<IDatatypeProvider> proxiedProviders) {
        this.proxiedProviders = CollectionUtil.unmodifiableList(new ArrayList<IDatatypeProvider>(proxiedProviders));
    }

    @NonNull
    protected List<IDatatypeProvider> getProxiedProviders() {
        return this.proxiedProviders;
    }

    @Override
    public Map<String, IDatatypeContent> getDatatypes() {
        return (Map)ObjectUtils.notNull((Object)this.proxiedProviders.stream().flatMap(provider -> provider.getDatatypes().values().stream()).collect(Collectors.toMap(content -> content.getTypeName(), Function.identity(), (e1, e2) -> e2, LinkedHashMap::new)));
    }

    @Override
    public Set<String> generateDatatypes(Set<String> requiredTypes, XMLStreamWriter2 writer) throws XMLStreamException {
        HashSet<String> retval = new HashSet<String>();
        for (IDatatypeProvider provider : this.getProxiedProviders()) {
            retval.addAll(provider.generateDatatypes(requiredTypes, writer));
        }
        return retval;
    }
}

