/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.model.common.IAssemblyDefinition;
import gov.nist.secauto.metaschema.model.common.IDefinition;
import gov.nist.secauto.metaschema.model.common.IFieldDefinition;
import gov.nist.secauto.metaschema.model.common.IFlagDefinition;
import gov.nist.secauto.metaschema.model.common.IMetaschema;
import gov.nist.secauto.metaschema.model.common.IValuedDefinition;
import gov.nist.secauto.metaschema.model.common.configuration.IConfiguration;
import gov.nist.secauto.metaschema.model.common.constraint.IAllowedValue;
import gov.nist.secauto.metaschema.model.common.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.AbstractGenerationState;
import gov.nist.secauto.metaschema.schemagen.SchemaGenerationFeature;
import gov.nist.secauto.metaschema.schemagen.json.datatype.JsonDatatypeManager;
import gov.nist.secauto.metaschema.schemagen.json.schema.AbstractDefinitionJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.schema.AssemblyDefinitionJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.schema.DataTypeJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.schema.DataTypeRestrictionDefinitionJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.schema.FieldDefinitionJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.schema.FlagDefinitionJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.schema.IDefineableJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.schema.IJsonSchema;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class JsonGenerationState
extends AbstractGenerationState<JsonGenerator, JsonDatatypeManager> {
    @NonNull
    private final Set<IDefineableJsonSchema> definitionSchemas = new LinkedHashSet<IDefineableJsonSchema>();
    @NonNull
    private final Map<IDefinition, IJsonSchema> definitionToSchemaMap = new ConcurrentHashMap<IDefinition, IJsonSchema>();
    @NonNull
    private final Map<IValuedDefinition, IJsonSchema> definitionValueToDataTypeSchemaMap = new ConcurrentHashMap<IValuedDefinition, IJsonSchema>();
    @NonNull
    private final Map<IDataTypeAdapter<?>, IJsonSchema> dataTypeToSchemaMap = new ConcurrentHashMap();

    public JsonGenerationState(@NonNull IMetaschema metaschema, @NonNull JsonGenerator writer, @NonNull IConfiguration<SchemaGenerationFeature<?>> configuration) {
        super(metaschema, writer, configuration, new JsonDatatypeManager());
    }

    @NonNull
    public IJsonSchema getDataTypeSchemaForDefinition(@NonNull IValuedDefinition definition) {
        IJsonSchema retval = this.definitionValueToDataTypeSchemaMap.get(definition);
        if (retval == null) {
            AbstractGenerationState.AllowedValueCollection allowedValuesCollection = JsonGenerationState.getContextIndependentEnumeratedValues(definition);
            List<IAllowedValue> allowedValues = allowedValuesCollection.getValues();
            if (allowedValues.isEmpty()) {
                retval = this.getSchema(definition.getJavaTypeAdapter());
            } else {
                DataTypeRestrictionDefinitionJsonSchema restriction = new DataTypeRestrictionDefinitionJsonSchema(definition, allowedValuesCollection);
                this.registerDefinitionSchema(restriction);
                retval = restriction;
            }
            this.definitionValueToDataTypeSchemaMap.put(definition, retval);
            retval.resolveSubSchemas(this);
        }
        return retval;
    }

    @NonNull
    public IJsonSchema getSchema(@NonNull IDefinition definition) {
        IJsonSchema retval = this.definitionToSchemaMap.get(definition);
        if (retval == null) {
            AbstractDefinitionJsonSchema definitionSchema;
            switch (definition.getModelType()) {
                case ASSEMBLY: {
                    definitionSchema = new AssemblyDefinitionJsonSchema((IAssemblyDefinition)definition);
                    break;
                }
                case FIELD: {
                    definitionSchema = new FieldDefinitionJsonSchema((IFieldDefinition)definition);
                    break;
                }
                case FLAG: {
                    definitionSchema = new FlagDefinitionJsonSchema((IFlagDefinition)definition);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(definition.getModelType().toString());
                }
            }
            this.definitionToSchemaMap.put(definition, definitionSchema);
            this.registerDefinitionSchema(definitionSchema);
            definitionSchema.resolveSubSchemas(this);
            retval = definitionSchema;
        }
        return retval;
    }

    @NonNull
    public IJsonSchema getSchema(@NonNull IDataTypeAdapter<?> datatype) {
        IJsonSchema retval = this.dataTypeToSchemaMap.get(datatype);
        if (retval == null) {
            retval = new DataTypeJsonSchema(((JsonDatatypeManager)this.getDatatypeManager()).getTypeNameForDatatype(datatype), datatype);
            this.dataTypeToSchemaMap.put(datatype, retval);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerDefinitionSchema(@NonNull IDefineableJsonSchema schema) {
        if (schema.isDefinition(this)) {
            Set<IDefineableJsonSchema> set = this.definitionSchemas;
            synchronized (set) {
                if (!this.definitionSchemas.contains(schema)) {
                    this.definitionSchemas.add(schema);
                }
            }
        }
    }

    public ObjectNode generateDefinitions() {
        ObjectNode definitionsObject = (ObjectNode)ObjectUtils.notNull((Object)JsonNodeFactory.instance.objectNode());
        for (IDefineableJsonSchema schema : this.definitionSchemas) {
            schema.generateDefinition(this, definitionsObject);
        }
        ((JsonDatatypeManager)this.getDatatypeManager()).generateDatatypes(definitionsObject);
        return definitionsObject;
    }

    public void writeStartObject() throws IOException {
        ((JsonGenerator)this.getWriter()).writeStartObject();
    }

    public void writeEndObject() throws IOException {
        ((JsonGenerator)this.getWriter()).writeEndObject();
    }

    public void writeField(String fieldName, String value) throws IOException {
        ((JsonGenerator)this.getWriter()).writeStringField(fieldName, value);
    }

    public void writeField(String fieldName, ObjectNode obj) throws IOException {
        JsonGenerator writer = (JsonGenerator)this.getWriter();
        writer.writeFieldName(fieldName);
        writer.writeTree((TreeNode)obj);
    }

    @Override
    public void flushWriter() throws IOException {
        ((JsonGenerator)this.getWriter()).flush();
    }
}

