/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.model.common.IDefinition;
import gov.nist.secauto.metaschema.model.common.IMetaschema;
import gov.nist.secauto.metaschema.model.common.IRootAssemblyDefinition;
import gov.nist.secauto.metaschema.model.common.configuration.IConfiguration;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.AbstractSchemaGenerator;
import gov.nist.secauto.metaschema.schemagen.SchemaGenerationException;
import gov.nist.secauto.metaschema.schemagen.SchemaGenerationFeature;
import gov.nist.secauto.metaschema.schemagen.json.JsonGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.datatype.JsonDatatypeManager;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class JsonSchemaGenerator
extends AbstractSchemaGenerator<JsonGenerator, JsonDatatypeManager, JsonGenerationState> {
    @NonNull
    private final JsonFactory jsonFactory;

    public JsonSchemaGenerator() {
        this(new JsonFactory());
    }

    public JsonSchemaGenerator(@NonNull JsonFactory jsonFactory) {
        this.jsonFactory = jsonFactory;
    }

    @NonNull
    public JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    @Override
    protected JsonGenerator newWriter(Writer out) {
        try {
            return (JsonGenerator)ObjectUtils.notNull((Object)this.getJsonFactory().createGenerator(out).setCodec((ObjectCodec)new ObjectMapper()).useDefaultPrettyPrinter().disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET));
        }
        catch (IOException ex) {
            throw new SchemaGenerationException(ex);
        }
    }

    @Override
    protected JsonGenerationState newGenerationState(IMetaschema metaschema, JsonGenerator schemaWriter, IConfiguration<SchemaGenerationFeature<?>> configuration) {
        return new JsonGenerationState(metaschema, schemaWriter, configuration);
    }

    @Override
    protected void generateSchema(JsonGenerationState state) {
        List<IRootAssemblyDefinition> rootAssemblyDefinitions = this.analyzeDefinitions(state, (entry, definition) -> {
            assert (entry != null);
            assert (definition != null);
            if (entry.isReferenced()) {
                state.getSchema((IDefinition)definition);
            }
        });
        if (rootAssemblyDefinitions.isEmpty()) {
            throw new SchemaGenerationException("No root definitions found");
        }
        List rootEntries = rootAssemblyDefinitions.stream().map(root -> {
            assert (root != null);
            return new RootPropertyEntry((IRootAssemblyDefinition)root, state);
        }).collect(Collectors.toUnmodifiableList());
        IMetaschema metaschema = state.getMetaschema();
        try {
            state.writeStartObject();
            state.writeField("$schema", "http://json-schema.org/draft-07/schema#");
            state.writeField("$id", String.format("%s/%s-%s-schema.json", metaschema.getXmlNamespace(), metaschema.getShortName(), metaschema.getVersion()));
            state.writeField("$comment", metaschema.getName().toMarkdown());
            state.writeField("type", "object");
            ObjectNode definitionsObject = state.generateDefinitions();
            if (!definitionsObject.isEmpty()) {
                state.writeField("definitions", definitionsObject);
            }
            JsonGenerator writer = (JsonGenerator)state.getWriter();
            if (rootEntries.size() == 1) {
                ((RootPropertyEntry)rootEntries.iterator().next()).write(writer);
            } else {
                writer.writeFieldName("oneOf");
                writer.writeStartArray();
                for (RootPropertyEntry root2 : rootEntries) {
                    assert (root2 != null);
                    writer.writeStartObject();
                    root2.write(writer);
                    writer.writeEndObject();
                }
                writer.writeEndArray();
            }
            state.writeEndObject();
        }
        catch (IOException ex) {
            throw new SchemaGenerationException(ex);
        }
    }

    @NonNull
    private static Map<String, ObjectNode> generateRootProperties(@NonNull IRootAssemblyDefinition definition, @NonNull JsonGenerationState state) {
        LinkedHashMap<String, ObjectNode> properties = new LinkedHashMap<String, ObjectNode>();
        properties.put("$schema", JsonNodeFactory.instance.objectNode().put("type", "string").put("format", "uri-reference"));
        ObjectNode rootObj = (ObjectNode)ObjectUtils.notNull((Object)JsonNodeFactory.instance.objectNode());
        state.getSchema((IDefinition)definition).generateSchemaOrRef(state, rootObj);
        properties.put(definition.getRootJsonName(), rootObj);
        return properties;
    }

    private static class RootPropertyEntry {
        @NonNull
        private final IRootAssemblyDefinition definition;
        @NonNull
        private final Map<String, ObjectNode> properties;

        public RootPropertyEntry(@NonNull IRootAssemblyDefinition definition, @NonNull JsonGenerationState state) {
            this.definition = definition;
            this.properties = JsonSchemaGenerator.generateRootProperties(definition, state);
        }

        @NonNull
        protected IRootAssemblyDefinition getDefinition() {
            return this.definition;
        }

        @NonNull
        protected Map<String, ObjectNode> getProperties() {
            return this.properties;
        }

        public void write(JsonGenerator writer) throws IOException {
            writer.writeFieldName("properties");
            writer.writeStartObject();
            for (Map.Entry<String, ObjectNode> entry : this.getProperties().entrySet()) {
                writer.writeFieldName(entry.getKey());
                writer.writeTree((TreeNode)entry.getValue());
            }
            writer.writeEndObject();
            writer.writeFieldName("required");
            writer.writeStartArray();
            writer.writeString(this.getDefinition().getRootJsonName());
            writer.writeEndArray();
            writer.writeBooleanField("additionalProperties", false);
        }
    }
}

