/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json.property;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.model.common.INamedInstance;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.json.JsonGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.property.IJsonProperty;
import gov.nist.secauto.metaschema.schemagen.json.schema.IJsonSchema;

public abstract class AbstractJsonProperty<I extends INamedInstance>
implements IJsonProperty<I> {
    @NonNull
    private final I instance;

    public AbstractJsonProperty(@NonNull I instance) {
        this.instance = instance;
    }

    @Override
    public I getInstance() {
        return this.instance;
    }

    @Override
    public String getName() {
        return this.getInstance().getJsonName();
    }

    protected abstract void generateBody(@NonNull ObjectNode var1, @NonNull JsonGenerationState var2);

    protected void generateSchemaOrRef(@NonNull ObjectNode obj, @NonNull JsonGenerationState state) {
        I instance = this.getInstance();
        IJsonSchema schema = state.getSchema(instance.getDefinition());
        schema.generateSchemaOrRef(state, obj);
    }

    @Override
    public void generateProperty(IJsonProperty.PropertyCollection properties, JsonGenerationState state) {
        ObjectNode contextObj = (ObjectNode)ObjectUtils.notNull((Object)JsonNodeFactory.instance.objectNode());
        this.generateBody(contextObj, state);
        String name = this.getName();
        properties.addProperty(name, contextObj);
        if (this.isRequired()) {
            properties.addRequired(name);
        }
    }
}

