/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json.property;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.model.common.INamedInstance;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.json.JsonGenerationState;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public interface IJsonProperty<I extends INamedInstance> {
    @NonNull
    public I getInstance();

    @NonNull
    public String getName();

    public boolean isRequired();

    public void generateProperty(@NonNull PropertyCollection var1, @NonNull JsonGenerationState var2);

    public static class PropertyCollection {
        private final Map<String, ObjectNode> properties;
        private final Set<String> required;

        public PropertyCollection() {
            this(new LinkedHashMap<String, ObjectNode>(), new LinkedHashSet<String>());
        }

        protected PropertyCollection(@NonNull Map<String, ObjectNode> properties, @NonNull Set<String> required) {
            this.properties = properties;
            this.required = required;
        }

        public Map<String, ObjectNode> getProperties() {
            return Collections.unmodifiableMap(this.properties);
        }

        public Set<String> getRequired() {
            return Collections.unmodifiableSet(this.required);
        }

        public void addProperty(@NonNull String name, @NonNull ObjectNode def) {
            this.properties.put(name, def);
        }

        public void addRequired(@NonNull String name) {
            this.required.add(name);
        }

        public PropertyCollection copy() {
            return new PropertyCollection(new LinkedHashMap<String, ObjectNode>(this.properties), new LinkedHashSet<String>(this.required));
        }

        public void generate(@NonNull ObjectNode obj) {
            if (!this.properties.isEmpty()) {
                ObjectNode propertiesNode = (ObjectNode)ObjectUtils.notNull((Object)JsonNodeFactory.instance.objectNode());
                for (Map.Entry<String, ObjectNode> entry : this.properties.entrySet()) {
                    propertiesNode.set(entry.getKey(), (JsonNode)entry.getValue());
                }
                obj.set("properties", (JsonNode)propertiesNode);
                if (!this.required.isEmpty()) {
                    ArrayNode requiredNode = (ArrayNode)ObjectUtils.notNull((Object)JsonNodeFactory.instance.arrayNode());
                    for (String requiredProperty : this.required) {
                        requiredNode.add(requiredProperty);
                    }
                    obj.set("required", (JsonNode)requiredNode);
                }
            }
        }
    }
}

