/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json.property;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.model.common.INamedModelInstance;
import gov.nist.secauto.metaschema.schemagen.json.property.AbstractNamedModelInstanceJsonProperty;
import gov.nist.secauto.metaschema.schemagen.json.property.IJsonProperty;
import gov.nist.secauto.metaschema.schemagen.json.property.KeyedNamedModelInstanceJsonProperty;
import gov.nist.secauto.metaschema.schemagen.json.property.ListNamedModelInstanceJsonProperty;
import gov.nist.secauto.metaschema.schemagen.json.property.SingletonNamedModelInstanceJsonProperty;
import gov.nist.secauto.metaschema.schemagen.json.property.SingletonOrListNamedModelInstanceJsonProperty;

public interface INamedModelInstanceJsonProperty
extends IJsonProperty<INamedModelInstance> {
    public int getMinOccurs();

    public int getMaxOccurs();

    public static INamedModelInstanceJsonProperty newProperty(@NonNull INamedModelInstance instance) {
        AbstractNamedModelInstanceJsonProperty retval;
        block6: {
            block5: {
                int maxOccurs = instance.getMaxOccurs();
                if (maxOccurs <= 1 && maxOccurs != -1) break block5;
                switch (instance.getJsonGroupAsBehavior()) {
                    case LIST: {
                        retval = new ListNamedModelInstanceJsonProperty(instance);
                        break block6;
                    }
                    case SINGLETON_OR_LIST: {
                        retval = new SingletonOrListNamedModelInstanceJsonProperty(instance);
                        break block6;
                    }
                    case KEYED: {
                        retval = new KeyedNamedModelInstanceJsonProperty(instance);
                        break block6;
                    }
                    default: {
                        throw new UnsupportedOperationException(String.format("Unsupported group-as in-json binding '%s'.", instance.getJsonGroupAsBehavior()));
                    }
                }
            }
            retval = new SingletonNamedModelInstanceJsonProperty(instance);
        }
        return retval;
    }
}

