/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json.property;

import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.model.common.INamedModelInstance;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.json.JsonGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.property.AbstractNamedModelInstanceJsonProperty;

public class ListNamedModelInstanceJsonProperty
extends AbstractNamedModelInstanceJsonProperty {
    public ListNamedModelInstanceJsonProperty(@NonNull INamedModelInstance instance) {
        super(instance);
    }

    protected int getMinimumItems() {
        return 1;
    }

    @Override
    protected void generateBody(ObjectNode obj, JsonGenerationState state) {
        obj.put("type", "array");
        ObjectNode items = (ObjectNode)ObjectUtils.notNull((Object)obj.putObject("items"));
        this.generateSchemaOrRef(items, state);
        obj.put("minItems", Math.max(this.getMinimumItems(), this.getMinOccurs()));
        int maxOccurs = this.getMaxOccurs();
        if (maxOccurs != -1) {
            obj.put("maxItems", maxOccurs);
        }
    }
}

