/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json.schema;

import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.model.common.IDefinition;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.schemagen.SchemaGenerationException;
import gov.nist.secauto.metaschema.schemagen.json.JsonGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.schema.AbstractDefineableJsonSchema;
import java.io.IOException;

public abstract class AbstractDefinitionJsonSchema<D extends IDefinition>
extends AbstractDefineableJsonSchema {
    @NonNull
    private final D definition;

    protected AbstractDefinitionJsonSchema(@NonNull D definition) {
        this.definition = definition;
    }

    @NonNull
    protected D getDefinition() {
        return this.definition;
    }

    @Override
    public boolean isInline(JsonGenerationState state) {
        return state.isInline((IDefinition)this.getDefinition());
    }

    @Override
    protected String generateDefinitionName(JsonGenerationState state) {
        return state.getTypeNameForDefinition((IDefinition)this.definition, null);
    }

    protected abstract void generateBody(@NonNull JsonGenerationState var1, @NonNull ObjectNode var2) throws IOException;

    @Override
    public void generateSchema(JsonGenerationState state, ObjectNode obj) {
        D definition = this.getDefinition();
        try {
            AbstractDefinitionJsonSchema.generateTitle(definition, obj);
            AbstractDefinitionJsonSchema.generateDescription(definition, obj);
            this.generateBody(state, obj);
        }
        catch (IOException ex) {
            throw new SchemaGenerationException(ex);
        }
    }

    public static void generateTitle(@NonNull IDefinition definition, @NonNull ObjectNode obj) {
        String formalName = definition.getEffectiveFormalName();
        if (formalName != null) {
            obj.put("title", formalName);
        }
    }

    public static void generateDescription(@NonNull IDefinition definition, @NonNull ObjectNode obj) {
        MarkupMultiline remarks;
        MarkupLine description = definition.getDescription();
        StringBuilder retval = null;
        if (description != null) {
            retval = new StringBuilder().append(description.toMarkdown());
        }
        if ((remarks = definition.getRemarks()) != null) {
            if (retval == null) {
                retval = new StringBuilder();
            } else {
                retval.append("\n\n");
            }
            retval.append(remarks.toMarkdown());
        }
        if (retval != null) {
            obj.put("description", retval.toString());
        }
    }
}

