/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.model.common.IAssemblyDefinition;
import gov.nist.secauto.metaschema.model.common.IChoiceInstance;
import gov.nist.secauto.metaschema.model.common.IDefinition;
import gov.nist.secauto.metaschema.model.common.IFlagInstance;
import gov.nist.secauto.metaschema.model.common.IModelInstance;
import gov.nist.secauto.metaschema.model.common.INamedModelInstance;
import gov.nist.secauto.metaschema.model.common.ModelType;
import gov.nist.secauto.metaschema.model.common.util.CollectionUtil;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.FlagInstanceFilter;
import gov.nist.secauto.metaschema.schemagen.json.JsonGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.property.FlagInstanceJsonProperty;
import gov.nist.secauto.metaschema.schemagen.json.property.IJsonProperty;
import gov.nist.secauto.metaschema.schemagen.json.property.INamedModelInstanceJsonProperty;
import gov.nist.secauto.metaschema.schemagen.json.schema.AbstractDefinitionJsonSchema;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class AssemblyDefinitionJsonSchema
extends AbstractDefinitionJsonSchema<IAssemblyDefinition> {
    public AssemblyDefinitionJsonSchema(@NonNull IAssemblyDefinition definition) {
        super(definition);
    }

    @Override
    public void resolveSubSchemas(JsonGenerationState state) {
        for (IFlagInstance instance : ((IAssemblyDefinition)this.getDefinition()).getFlagInstances()) {
            state.getSchema((IDefinition)instance.getDefinition());
        }
        for (IFlagInstance instance : ((IAssemblyDefinition)this.getDefinition()).getNamedModelInstances()) {
            state.getSchema((IDefinition)instance.getDefinition());
        }
    }

    @Override
    protected void generateBody(JsonGenerationState state, ObjectNode obj) throws IOException {
        IAssemblyDefinition definition = (IAssemblyDefinition)this.getDefinition();
        obj.put("type", "object");
        IFlagInstance jsonKeyFlag = definition.getJsonKeyFlagInstance();
        Collection<? extends IFlagInstance> flags = FlagInstanceFilter.filterFlags(definition.getFlagInstances(), jsonKeyFlag);
        IJsonProperty.PropertyCollection properties = new IJsonProperty.PropertyCollection();
        for (IFlagInstance iFlagInstance : flags) {
            assert (iFlagInstance != null);
            new FlagInstanceJsonProperty(iFlagInstance).generateProperty(properties, state);
        }
        Collection instances = definition.getNamedModelInstances();
        for (INamedModelInstance instance : instances) {
            assert (instance != null);
            INamedModelInstanceJsonProperty.newProperty(instance).generateProperty(properties, state);
        }
        List list = definition.getChoiceInstances();
        if (list.isEmpty()) {
            properties.generate(obj);
            obj.put("additionalProperties", false);
        } else {
            this.generateChoices(list, properties, obj, state);
        }
    }

    protected void generateChoices(@NonNull Collection<? extends IChoiceInstance> choices, @NonNull IJsonProperty.PropertyCollection properties, @NonNull ObjectNode definitionNode, @NonNull JsonGenerationState state) throws IOException {
        List<IJsonProperty.PropertyCollection> propertyChoices = CollectionUtil.singletonList((Object)properties);
        if ((propertyChoices = this.explodeChoices(choices, propertyChoices, state)).size() == 1) {
            propertyChoices.iterator().next().generate(definitionNode);
        } else if (propertyChoices.size() > 1) {
            ArrayNode anyOfdNode = (ArrayNode)ObjectUtils.notNull((Object)JsonNodeFactory.instance.arrayNode());
            for (IJsonProperty.PropertyCollection propertyChoice : propertyChoices) {
                ObjectNode choiceDefinitionNode = (ObjectNode)ObjectUtils.notNull((Object)JsonNodeFactory.instance.objectNode());
                propertyChoice.generate(choiceDefinitionNode);
                choiceDefinitionNode.put("additionalProperties", false);
                anyOfdNode.add((JsonNode)choiceDefinitionNode);
            }
            definitionNode.set("anyOf", (JsonNode)anyOfdNode);
        }
    }

    protected List<IJsonProperty.PropertyCollection> explodeChoices(@NonNull Collection<? extends IChoiceInstance> choices, @NonNull List<IJsonProperty.PropertyCollection> propertyChoices, @NonNull JsonGenerationState state) throws IOException {
        List<IJsonProperty.PropertyCollection> retval = propertyChoices;
        for (IChoiceInstance iChoiceInstance : choices) {
            LinkedList<IJsonProperty.PropertyCollection> newRetval = new LinkedList<IJsonProperty.PropertyCollection>();
            for (IModelInstance optionInstance : iChoiceInstance.getModelInstances()) {
                if (ModelType.CHOICE.equals((Object)optionInstance.getModelType())) {
                    newRetval.addAll(this.explodeChoices(CollectionUtil.singleton((Object)((IChoiceInstance)optionInstance)), retval, state));
                    continue;
                }
                for (IJsonProperty.PropertyCollection oldInstanceProperties : retval) {
                    IJsonProperty.PropertyCollection newInstanceProperties = oldInstanceProperties.copy();
                    INamedModelInstanceJsonProperty.newProperty((INamedModelInstance)optionInstance).generateProperty(newInstanceProperties, state);
                    newRetval.add(newInstanceProperties);
                }
            }
            retval = newRetval;
        }
        return retval;
    }
}

