/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.model.common.IDefinition;
import gov.nist.secauto.metaschema.model.common.IValuedDefinition;
import gov.nist.secauto.metaschema.model.common.constraint.IAllowedValue;
import gov.nist.secauto.metaschema.model.common.util.CollectionUtil;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.AbstractGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.JsonGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.schema.AbstractDefineableJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.schema.IJsonSchema;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;

public class DataTypeRestrictionDefinitionJsonSchema
extends AbstractDefineableJsonSchema {
    @NonNull
    private final IValuedDefinition definition;
    @NonNull
    private final AbstractGenerationState.AllowedValueCollection allowedValuesCollection;

    public DataTypeRestrictionDefinitionJsonSchema(@NonNull IValuedDefinition definition, @NonNull AbstractGenerationState.AllowedValueCollection allowedValuesCollection) {
        this.definition = definition;
        CollectionUtil.requireNonEmpty(allowedValuesCollection.getValues());
        this.allowedValuesCollection = allowedValuesCollection;
    }

    @Override
    public void resolveSubSchemas(JsonGenerationState state) {
    }

    @NonNull
    protected IValuedDefinition getDefinition() {
        return this.definition;
    }

    @NonNull
    protected AbstractGenerationState.AllowedValueCollection getAllowedValuesCollection() {
        return this.allowedValuesCollection;
    }

    @Override
    public boolean isInline(JsonGenerationState state) {
        return state.isInline((IDefinition)this.getDefinition());
    }

    @Override
    protected String generateDefinitionName(JsonGenerationState state) {
        return state.getTypeNameForDefinition((IDefinition)this.definition, "Value");
    }

    @Override
    public void generateSchema(JsonGenerationState state, ObjectNode obj) {
        ArrayNode enumArray = JsonNodeFactory.instance.arrayNode();
        AbstractGenerationState.AllowedValueCollection allowedValuesCollection = this.getAllowedValuesCollection();
        block6: for (IAllowedValue allowedValue : allowedValuesCollection.getValues()) {
            switch (this.getDefinition().getJavaTypeAdapter().getJsonRawType()) {
                case STRING: {
                    enumArray.add(allowedValue.getValue());
                    continue block6;
                }
                case BOOLEAN: {
                    enumArray.add(Boolean.parseBoolean(allowedValue.getValue()));
                    continue block6;
                }
                case INTEGER: {
                    enumArray.add(new BigInteger(allowedValue.getValue()));
                    continue block6;
                }
                case NUMBER: {
                    enumArray.add(new BigDecimal(allowedValue.getValue(), MathContext.DECIMAL64));
                    continue block6;
                }
            }
            throw new UnsupportedOperationException(this.getDefinition().getJavaTypeAdapter().getJsonRawType().toString());
        }
        IJsonSchema dataTypeSchema = state.getSchema(this.getDefinition().getJavaTypeAdapter());
        ArrayNode ofArray = allowedValuesCollection.isClosed() ? obj.putArray("allOf") : obj.putArray("anyOf");
        dataTypeSchema.generateSchemaOrRef(state, (ObjectNode)ObjectUtils.notNull((Object)ofArray.addObject()));
        ofArray.addObject().set("enum", (JsonNode)enumArray);
    }
}

