/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.model.common.IDefinition;
import gov.nist.secauto.metaschema.model.common.IFieldDefinition;
import gov.nist.secauto.metaschema.model.common.IFlagInstance;
import gov.nist.secauto.metaschema.model.common.IValuedDefinition;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.FlagInstanceFilter;
import gov.nist.secauto.metaschema.schemagen.json.JsonGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.property.FlagInstanceJsonProperty;
import gov.nist.secauto.metaschema.schemagen.json.property.IJsonProperty;
import gov.nist.secauto.metaschema.schemagen.json.schema.AbstractDefinitionJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.schema.IJsonSchema;
import java.io.IOException;
import java.util.Collection;

public class FieldDefinitionJsonSchema
extends AbstractDefinitionJsonSchema<IFieldDefinition> {
    public FieldDefinitionJsonSchema(@NonNull IFieldDefinition definition) {
        super(definition);
    }

    @Override
    public void resolveSubSchemas(JsonGenerationState state) {
        state.getDataTypeSchemaForDefinition((IValuedDefinition)this.getDefinition());
        for (IFlagInstance instance : ((IFieldDefinition)this.getDefinition()).getFlagInstances()) {
            state.getSchema((IDefinition)instance.getDefinition());
        }
    }

    @Override
    protected void generateBody(JsonGenerationState state, ObjectNode obj) throws IOException {
        IFieldDefinition definition = (IFieldDefinition)this.getDefinition();
        Collection<? extends IFlagInstance> flags = definition.getFlagInstances();
        IFlagInstance jsonKeyFlag = definition.getJsonKeyFlagInstance();
        if (flags.isEmpty() || jsonKeyFlag != null && flags.size() == 1) {
            state.getDataTypeSchemaForDefinition((IValuedDefinition)definition).generateSchemaOrRef(state, obj);
        } else {
            obj.put("type", "object");
            IFlagInstance jsonValueKeyFlag = definition.getJsonValueKeyFlagInstance();
            flags = FlagInstanceFilter.filterFlags(flags, jsonKeyFlag, jsonValueKeyFlag);
            IJsonProperty.PropertyCollection properties = new IJsonProperty.PropertyCollection();
            for (IFlagInstance iFlagInstance : flags) {
                assert (iFlagInstance != null);
                new FlagInstanceJsonProperty(iFlagInstance).generateProperty(properties, state);
            }
            if (jsonValueKeyFlag == null) {
                if (definition.isCollapsible()) {
                    this.generateCollapsibleFieldValueInstance(properties, state);
                } else {
                    this.generateSimpleFieldValueInstance(properties, state);
                }
            }
            properties.generate(obj);
            if (jsonValueKeyFlag == null) {
                obj.put("additionalProperties", false);
            } else {
                ObjectNode additionalPropertiesTypeNode;
                if (definition.isCollapsible()) {
                    additionalPropertiesTypeNode = this.generateCollapsibleFieldValueType(state);
                } else {
                    additionalPropertiesTypeNode = (ObjectNode)ObjectUtils.notNull((Object)JsonNodeFactory.instance.objectNode());
                    state.getDataTypeSchemaForDefinition((IValuedDefinition)definition).generateSchemaOrRef(state, additionalPropertiesTypeNode);
                }
                ObjectNode objectNode = (ObjectNode)ObjectUtils.notNull((Object)JsonNodeFactory.instance.objectNode());
                ArrayNode allOf = objectNode.putArray("allOf");
                allOf.add((JsonNode)additionalPropertiesTypeNode);
                allOf.addObject().put("minProperties", properties.getRequired().size() + 1).put("maxProperties", properties.getProperties().size() + 1);
                obj.set("additionalProperties", (JsonNode)objectNode);
            }
        }
    }

    public void generateSimpleFieldValueInstance(@NonNull IJsonProperty.PropertyCollection properties, @NonNull JsonGenerationState state) {
        IFieldDefinition definition = (IFieldDefinition)this.getDefinition();
        String propertyName = definition.getJsonValueKeyName();
        ObjectNode propertyObject = (ObjectNode)ObjectUtils.notNull((Object)JsonNodeFactory.instance.objectNode());
        state.getDataTypeSchemaForDefinition((IValuedDefinition)definition).generateSchemaOrRef(state, propertyObject);
        properties.addProperty(propertyName, propertyObject);
        properties.addRequired(propertyName);
    }

    public void generateCollapsibleFieldValueInstance(@NonNull IJsonProperty.PropertyCollection properties, @NonNull JsonGenerationState state) {
        String propertyName = ((IFieldDefinition)this.getDefinition()).getJsonValueKeyName();
        properties.addProperty(propertyName, this.generateCollapsibleFieldValueType(state));
        properties.addRequired(propertyName);
    }

    @NonNull
    public ObjectNode generateCollapsibleFieldValueType(@NonNull JsonGenerationState state) {
        IJsonSchema schema = state.getDataTypeSchemaForDefinition((IValuedDefinition)this.getDefinition());
        ObjectNode retval = JsonNodeFactory.instance.objectNode();
        ArrayNode oneOf = retval.putArray("oneOf");
        schema.generateSchemaOrRef(state, (ObjectNode)ObjectUtils.notNull((Object)oneOf.addObject()));
        ObjectNode itemsObj = (ObjectNode)ObjectUtils.notNull((Object)oneOf.addObject().put("type", "array").put("minItems", 1).putObject("items"));
        schema.generateSchemaOrRef(state, itemsObj);
        return retval;
    }
}

