/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json.schema;

import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.json.JsonGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.schema.IJsonSchema;

public interface IDefineableJsonSchema
extends IJsonSchema {
    default public boolean isDefinition(@NonNull JsonGenerationState state) {
        return !this.isInline(state);
    }

    @NonNull
    public String getDefinitionName(@NonNull JsonGenerationState var1);

    default public String getDefinitionRef(@NonNull JsonGenerationState state) {
        if (!this.isDefinition(state)) {
            throw new IllegalStateException();
        }
        return (String)ObjectUtils.notNull((Object)("#/definitions/" + this.getDefinitionName(state)));
    }

    @Override
    default public void generateSchemaOrRef(@NonNull JsonGenerationState state, @NonNull ObjectNode obj) {
        if (this.isDefinition(state)) {
            obj.put("$ref", this.getDefinitionRef(state));
        } else {
            this.generateSchema(state, obj);
        }
    }

    default public void generateDefinition(@NonNull JsonGenerationState state, @NonNull ObjectNode definitionsObject) {
        if (!this.isDefinition(state)) {
            throw new IllegalStateException();
        }
        ObjectNode definitionObj = (ObjectNode)ObjectUtils.notNull((Object)definitionsObject.putObject(this.getDefinitionName(state)));
        definitionObj.put("$id", this.getDefinitionRef(state));
        this.generateSchema(state, definitionObj);
    }
}

