/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.xml;

import com.ctc.wstx.stax.WstxOutputFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gov.nist.secauto.metaschema.model.common.IAssemblyDefinition;
import gov.nist.secauto.metaschema.model.common.IDefinition;
import gov.nist.secauto.metaschema.model.common.IMetaschema;
import gov.nist.secauto.metaschema.model.common.IRootAssemblyDefinition;
import gov.nist.secauto.metaschema.model.common.configuration.IConfiguration;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.model.common.util.AutoCloser;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.AbstractSchemaGenerator;
import gov.nist.secauto.metaschema.schemagen.SchemaGenerationException;
import gov.nist.secauto.metaschema.schemagen.SchemaGenerationFeature;
import gov.nist.secauto.metaschema.schemagen.xml.XmlGenerationState;
import gov.nist.secauto.metaschema.schemagen.xml.datatype.XmlDatatypeManager;
import gov.nist.secauto.metaschema.schemagen.xml.schematype.IXmlType;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.Xslt30Transformer;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import org.codehaus.stax2.XMLOutputFactory2;
import org.codehaus.stax2.XMLStreamWriter2;

public class XmlSchemaGenerator
extends AbstractSchemaGenerator<AutoCloser<XMLStreamWriter2, SchemaGenerationException>, XmlDatatypeManager, XmlGenerationState> {
    @NonNull
    public static final String PREFIX_XML_SCHEMA = "xs";
    @NonNull
    public static final String NS_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    @NonNull
    private static final String PREFIX_XML_SCHEMA_VERSIONING = "vs";
    @NonNull
    private static final String NS_XML_SCHEMA_VERSIONING = "http://www.w3.org/2007/XMLSchema-versioning";
    @NonNull
    public static final String NS_XHTML = "http://www.w3.org/1999/xhtml";
    @NonNull
    private final XMLOutputFactory2 xmlOutputFactory;

    @NonNull
    private static XMLOutputFactory2 defaultXMLOutputFactory() {
        XMLOutputFactory2 xmlOutputFactory = (XMLOutputFactory2)XMLOutputFactory.newInstance();
        assert (xmlOutputFactory instanceof WstxOutputFactory);
        xmlOutputFactory.configureForSpeed();
        xmlOutputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", (Object)true);
        return xmlOutputFactory;
    }

    public XmlSchemaGenerator() {
        this(XmlSchemaGenerator.defaultXMLOutputFactory());
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public XmlSchemaGenerator(@NonNull XMLOutputFactory2 xmlOutputFactory) {
        this.xmlOutputFactory = xmlOutputFactory;
    }

    protected XMLOutputFactory2 getXmlOutputFactory() {
        return this.xmlOutputFactory;
    }

    @Override
    protected AutoCloser<XMLStreamWriter2, SchemaGenerationException> newWriter(Writer out) {
        XMLStreamWriter2 writer;
        try {
            writer = (XMLStreamWriter2)ObjectUtils.notNull((Object)((XMLStreamWriter2)this.getXmlOutputFactory().createXMLStreamWriter(out)));
        }
        catch (XMLStreamException ex) {
            throw new SchemaGenerationException(ex);
        }
        return AutoCloser.autoClose((Object)writer, t -> {
            try {
                t.close();
            }
            catch (XMLStreamException ex) {
                throw new SchemaGenerationException(ex);
            }
        });
    }

    @Override
    protected XmlGenerationState newGenerationState(IMetaschema metaschema, AutoCloser<XMLStreamWriter2, SchemaGenerationException> schemaWriter, IConfiguration<SchemaGenerationFeature<?>> configuration) {
        return new XmlGenerationState(metaschema, schemaWriter, configuration);
    }

    @Override
    public void generateFromMetaschema(@NonNull IMetaschema metaschema, @NonNull Writer out, @NonNull IConfiguration<SchemaGenerationFeature<?>> configuration) {
        try (StringWriter stringWriter = new StringWriter();){
            super.generateFromMetaschema(metaschema, stringWriter, configuration);
            stringWriter.flush();
            try (StringReader stringReader = new StringReader(stringWriter.toString());){
                Processor processor = new Processor(false);
                XsltCompiler compiler = processor.newXsltCompiler();
                try (InputStream is = this.getClass().getResourceAsStream("/identity.xsl");){
                    XsltExecutable stylesheet = compiler.compile((Source)new StreamSource(is));
                    Xslt30Transformer transformer = stylesheet.load30();
                    Serializer serializer = processor.newSerializer(out);
                    StreamSource source = new StreamSource(stringReader);
                    transformer.transform((Source)source, (Destination)serializer);
                }
            }
        }
        catch (IOException | SaxonApiException ex) {
            throw new SchemaGenerationException(ex);
        }
    }

    @Override
    protected void generateSchema(XmlGenerationState state) {
        try {
            String targetNS = state.getDefaultNS();
            HashMap prefixToNamespaceMap = new HashMap();
            List<IRootAssemblyDefinition> rootAssemblyDefinitions = this.analyzeDefinitions(state, (entry, definition) -> {
                QName qname;
                String namespace;
                assert (entry != null);
                assert (definition != null);
                IXmlType type = state.getTypeForDefinition((IDefinition)definition);
                if (!entry.isInline() && !targetNS.equals(namespace = (qname = type.getQName()).getNamespaceURI())) {
                    prefixToNamespaceMap.computeIfAbsent(qname.getPrefix(), x -> namespace);
                }
            });
            XMLStreamWriter2 writer = state.getXMLStreamWriter();
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeStartElement(PREFIX_XML_SCHEMA, "schema", NS_XML_SCHEMA);
            writer.writeDefaultNamespace(targetNS);
            writer.writeNamespace(PREFIX_XML_SCHEMA_VERSIONING, NS_XML_SCHEMA_VERSIONING);
            for (Map.Entry entry2 : prefixToNamespaceMap.entrySet()) {
                state.writeNamespace((String)entry2.getKey(), (String)entry2.getValue());
            }
            IMetaschema metaschema = state.getMetaschema();
            writer.writeAttribute("targetNamespace", targetNS);
            writer.writeAttribute("elementFormDefault", "qualified");
            writer.writeAttribute(NS_XML_SCHEMA_VERSIONING, "minVersion", "1.0");
            writer.writeAttribute(NS_XML_SCHEMA_VERSIONING, "maxVersion", "1.1");
            writer.writeAttribute("version", metaschema.getVersion());
            XmlSchemaGenerator.generateSchemaMetadata(metaschema, state);
            for (IAssemblyDefinition iAssemblyDefinition : rootAssemblyDefinitions) {
                QName xmlQName = iAssemblyDefinition.getRootXmlQName();
                if (xmlQName == null || xmlQName.getNamespaceURI() != null && !state.getDefaultNS().equals(xmlQName.getNamespaceURI())) continue;
                XmlSchemaGenerator.generateRootElement(iAssemblyDefinition, state);
            }
            state.generateXmlTypes();
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
        }
        catch (XMLStreamException ex) {
            throw new SchemaGenerationException(ex);
        }
    }

    protected static void generateSchemaMetadata(@NonNull IMetaschema metaschema, @NonNull XmlGenerationState state) throws XMLStreamException {
        String targetNS = (String)ObjectUtils.notNull((Object)metaschema.getXmlNamespace().toASCIIString());
        state.writeStartElement(PREFIX_XML_SCHEMA, "annotation", NS_XML_SCHEMA);
        state.writeStartElement(PREFIX_XML_SCHEMA, "appinfo", NS_XML_SCHEMA);
        state.writeStartElement(targetNS, "schema-name");
        metaschema.getName().writeXHtml(targetNS, state.getXMLStreamWriter());
        state.writeEndElement();
        state.writeStartElement(targetNS, "schema-version");
        state.writeCharacters(metaschema.getVersion());
        state.writeEndElement();
        state.writeStartElement(targetNS, "short-name");
        state.writeCharacters(metaschema.getShortName());
        state.writeEndElement();
        state.writeEndElement();
        MarkupMultiline remarks = metaschema.getRemarks();
        if (remarks != null) {
            state.writeStartElement(PREFIX_XML_SCHEMA, "documentation", NS_XML_SCHEMA);
            remarks.writeXHtml(targetNS, state.getXMLStreamWriter());
            state.writeEndElement();
        }
        state.writeEndElement();
    }

    private static void generateRootElement(@NonNull IAssemblyDefinition definition, @NonNull XmlGenerationState state) throws XMLStreamException {
        assert (definition.isRoot());
        XMLStreamWriter2 writer = state.getXMLStreamWriter();
        QName xmlQName = definition.getRootXmlQName();
        writer.writeStartElement(PREFIX_XML_SCHEMA, "element", NS_XML_SCHEMA);
        writer.writeAttribute("name", xmlQName.getLocalPart());
        writer.writeAttribute("type", state.getTypeForDefinition((IDefinition)definition).getTypeReference());
        writer.writeEndElement();
    }
}

