/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.xml.datatype;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.datatype.AbstractDatatypeManager;
import gov.nist.secauto.metaschema.schemagen.datatype.IDatatypeProvider;
import gov.nist.secauto.metaschema.schemagen.xml.datatype.XmlCoreDatatypeProvider;
import gov.nist.secauto.metaschema.schemagen.xml.datatype.XmlMarkupLineDatatypeProvider;
import gov.nist.secauto.metaschema.schemagen.xml.datatype.XmlMarkupMultilineDatatypeProvider;
import gov.nist.secauto.metaschema.schemagen.xml.datatype.XmlProseCompositDatatypeProvider;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamWriter2;

public class XmlDatatypeManager
extends AbstractDatatypeManager {
    public static final String NS_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    @NonNull
    private static final List<IDatatypeProvider> DATATYPE_PROVIDERS = (List)ObjectUtils.notNull(List.of(new XmlCoreDatatypeProvider(), new XmlProseCompositDatatypeProvider((List)ObjectUtils.notNull(List.of(new XmlMarkupMultilineDatatypeProvider(), new XmlMarkupLineDatatypeProvider())))));

    public void generateDatatypes(@NonNull XMLStreamWriter2 writer) throws XMLStreamException {
        Set<String> used = this.getUsedTypes();
        Set requiredTypes = XmlDatatypeManager.getDatatypeTranslationMap().values().stream().filter(type -> used.contains(type)).collect(Collectors.toCollection(LinkedHashSet::new));
        for (IDatatypeProvider provider : DATATYPE_PROVIDERS) {
            Set<String> providedDatatypes = provider.generateDatatypes(requiredTypes, writer);
            requiredTypes.removeAll(providedDatatypes);
        }
        if (!requiredTypes.isEmpty()) {
            throw new IllegalStateException(String.format("The following datatypes were not provided: %s", requiredTypes.stream().collect(Collectors.joining(","))));
        }
    }
}

