/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.xml.schematype;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.model.common.IAssemblyDefinition;
import gov.nist.secauto.metaschema.model.common.IChoiceInstance;
import gov.nist.secauto.metaschema.model.common.IDefinition;
import gov.nist.secauto.metaschema.model.common.IFieldInstance;
import gov.nist.secauto.metaschema.model.common.IFlagContainer;
import gov.nist.secauto.metaschema.model.common.IFlagInstance;
import gov.nist.secauto.metaschema.model.common.IModelInstance;
import gov.nist.secauto.metaschema.model.common.INamedInstance;
import gov.nist.secauto.metaschema.model.common.INamedModelInstance;
import gov.nist.secauto.metaschema.model.common.XmlGroupAsBehavior;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupDataTypeProvider;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.SchemaGenerationException;
import gov.nist.secauto.metaschema.schemagen.xml.DocumentationGenerator;
import gov.nist.secauto.metaschema.schemagen.xml.XmlGenerationState;
import gov.nist.secauto.metaschema.schemagen.xml.schematype.AbstractXmlComplexType;
import gov.nist.secauto.metaschema.schemagen.xml.schematype.IXmlType;
import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public class XmlComplexTypeAssemblyDefinition
extends AbstractXmlComplexType<IAssemblyDefinition> {
    public XmlComplexTypeAssemblyDefinition(@NonNull QName qname, @NonNull IAssemblyDefinition definition) {
        super(qname, definition);
    }

    @Override
    protected void generateTypeBody(XmlGenerationState state) throws XMLStreamException {
        Collection flagInstances;
        IAssemblyDefinition definition = (IAssemblyDefinition)this.getDefinition();
        Collection modelInstances = definition.getModelInstances();
        if (!modelInstances.isEmpty()) {
            state.writeStartElement("xs", "sequence", "http://www.w3.org/2001/XMLSchema");
            for (IModelInstance modelInstance : modelInstances) {
                assert (modelInstance != null);
                this.generateModelInstance(modelInstance, state);
            }
            state.writeEndElement();
        }
        if (!(flagInstances = definition.getFlagInstances()).isEmpty()) {
            for (IFlagInstance flagInstance : flagInstances) {
                assert (flagInstance != null);
                XmlComplexTypeAssemblyDefinition.generateFlagInstance(flagInstance, state);
            }
        }
    }

    protected void generateModelInstance(@NonNull IModelInstance modelInstance, @NonNull XmlGenerationState state) throws XMLStreamException {
        boolean grouped = false;
        if (XmlGroupAsBehavior.GROUPED.equals((Object)modelInstance.getXmlGroupAsBehavior())) {
            state.writeStartElement("xs", "element", "http://www.w3.org/2001/XMLSchema");
            QName groupAsQName = (QName)ObjectUtils.requireNonNull((Object)modelInstance.getXmlGroupAsQName());
            if (!state.getDefaultNS().equals(groupAsQName.getNamespaceURI())) {
                throw new SchemaGenerationException(String.format("Attempt to create element '%s' on definition '%s' with different namespace", groupAsQName, ((IAssemblyDefinition)this.getDefinition()).toCoordinates()));
            }
            state.writeAttribute("name", (String)ObjectUtils.requireNonNull((Object)groupAsQName.getLocalPart()));
            if (modelInstance.getMinOccurs() == 0) {
                state.writeAttribute("minOccurs", "0");
            }
            state.writeStartElement("xs", "complexType", "http://www.w3.org/2001/XMLSchema");
            state.writeStartElement("xs", "sequence", "http://www.w3.org/2001/XMLSchema");
            grouped = true;
        }
        switch (modelInstance.getModelType()) {
            case ASSEMBLY: {
                this.generateNamedModelInstance((INamedModelInstance)modelInstance, grouped, state);
                break;
            }
            case FIELD: {
                IFieldInstance fieldInstance = (IFieldInstance)modelInstance;
                if (!fieldInstance.isInXmlWrapped() && fieldInstance.getDefinition().getJavaTypeAdapter().isUnrappedValueAllowedInXml()) {
                    XmlComplexTypeAssemblyDefinition.generateUnwrappedFieldInstance(fieldInstance, grouped, state);
                    break;
                }
                this.generateNamedModelInstance((INamedModelInstance)fieldInstance, grouped, state);
                break;
            }
            case CHOICE: {
                this.generateChoiceModelInstance((IChoiceInstance)modelInstance, state);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (grouped) {
            state.writeEndElement();
            state.writeEndElement();
            state.writeEndElement();
        }
    }

    protected void generateNamedModelInstance(@NonNull INamedModelInstance modelInstance, boolean grouped, @NonNull XmlGenerationState state) throws XMLStreamException {
        state.writeStartElement("xs", "element", "http://www.w3.org/2001/XMLSchema");
        state.writeAttribute("name", modelInstance.getEffectiveName());
        if (!grouped && modelInstance.getMinOccurs() != 1) {
            state.writeAttribute("minOccurs", (String)ObjectUtils.notNull((Object)Integer.toString(modelInstance.getMinOccurs())));
        }
        if (modelInstance.getMaxOccurs() != 1) {
            state.writeAttribute("maxOccurs", modelInstance.getMaxOccurs() == -1 ? "unbounded" : (String)ObjectUtils.notNull((Object)Integer.toString(modelInstance.getMaxOccurs())));
        }
        IFlagContainer definition = modelInstance.getDefinition();
        IXmlType type = state.getTypeForDefinition((IDefinition)definition);
        if (state.isInline((IDefinition)definition)) {
            DocumentationGenerator.generateDocumentation((INamedInstance)modelInstance, state);
            type.generateType(state, true);
        } else {
            state.writeAttribute("type", type.getTypeReference());
            DocumentationGenerator.generateDocumentation((INamedInstance)modelInstance, state);
        }
        state.writeEndElement();
    }

    protected static void generateUnwrappedFieldInstance(@NonNull IFieldInstance fieldInstance, boolean grouped, @NonNull XmlGenerationState state) throws XMLStreamException {
        if (!MarkupDataTypeProvider.MARKUP_MULTILINE.equals(fieldInstance.getDefinition().getJavaTypeAdapter())) {
            throw new IllegalStateException();
        }
        state.writeStartElement("xs", "group", "http://www.w3.org/2001/XMLSchema");
        state.writeAttribute("ref", "blockElementGroup");
        if (!grouped && fieldInstance.getMinOccurs() != 1) {
            state.writeAttribute("minOccurs", (String)ObjectUtils.notNull((Object)Integer.toString(fieldInstance.getMinOccurs())));
        }
        state.writeAttribute("maxOccurs", "unbounded");
        DocumentationGenerator.generateDocumentation((INamedInstance)fieldInstance, state);
        state.writeEndElement();
    }

    protected void generateChoiceModelInstance(@NonNull IChoiceInstance choice, @NonNull XmlGenerationState state) throws XMLStreamException {
        state.writeStartElement("xs", "choice", "http://www.w3.org/2001/XMLSchema");
        for (IModelInstance instance : choice.getModelInstances()) {
            assert (instance != null);
            if (instance instanceof IChoiceInstance) {
                this.generateChoiceModelInstance((IChoiceInstance)instance, state);
                continue;
            }
            this.generateModelInstance(instance, state);
        }
        state.writeEndElement();
    }
}

