/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.xml.schematype;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.model.common.IValuedDefinition;
import gov.nist.secauto.metaschema.model.common.constraint.IAllowedValue;
import gov.nist.secauto.metaschema.model.common.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.AbstractGenerationState;
import gov.nist.secauto.metaschema.schemagen.SchemaGenerationException;
import gov.nist.secauto.metaschema.schemagen.xml.XmlGenerationState;
import gov.nist.secauto.metaschema.schemagen.xml.schematype.AbstractXmlSimpleType;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamWriter2;

public class XmlSimpleTypeDataTypeRestriction
extends AbstractXmlSimpleType {
    @NonNull
    private final AbstractGenerationState.AllowedValueCollection allowedValuesCollection;

    public XmlSimpleTypeDataTypeRestriction(@NonNull QName qname, @NonNull IValuedDefinition definition, @NonNull AbstractGenerationState.AllowedValueCollection allowedValuesCollection) {
        super(qname, definition);
        this.allowedValuesCollection = allowedValuesCollection;
    }

    protected AbstractGenerationState.AllowedValueCollection getAllowedValuesCollection() {
        return this.allowedValuesCollection;
    }

    @Override
    public void generateType(XmlGenerationState state, boolean anonymous) {
        try {
            state.writeStartElement("xs", "simpleType", "http://www.w3.org/2001/XMLSchema");
            if (!anonymous) {
                state.writeAttribute("name", (String)ObjectUtils.notNull((Object)this.getQName().getLocalPart()));
            }
            state.writeStartElement("xs", "restriction", "http://www.w3.org/2001/XMLSchema");
            state.writeAttribute("base", state.getSimpleType(this.getDataTypeAdapter()).getTypeReference());
            for (IAllowedValue allowedValue : this.getAllowedValuesCollection().getValues()) {
                state.writeStartElement("xs", "enumeration", "http://www.w3.org/2001/XMLSchema");
                state.writeAttribute("value", allowedValue.getValue());
                MarkupLine description = allowedValue.getDescription();
                XmlSimpleTypeDataTypeRestriction.generateDescriptionAnnotation(description, (String)ObjectUtils.notNull((Object)this.getQName().getNamespaceURI()), state);
                state.writeEndElement();
            }
            state.writeEndElement();
            state.writeEndElement();
        }
        catch (XMLStreamException ex) {
            throw new SchemaGenerationException(ex);
        }
    }

    public static void generateDescriptionAnnotation(@NonNull MarkupLine description, @NonNull String xmlNS, @NonNull XmlGenerationState state) throws XMLStreamException {
        XMLStreamWriter2 writer = state.getXMLStreamWriter();
        writer.writeStartElement("xs", "annotation", "http://www.w3.org/2001/XMLSchema");
        writer.writeStartElement("xs", "documentation", "http://www.w3.org/2001/XMLSchema");
        writer.writeStartElement(xmlNS, "p");
        description.writeXHtml(xmlNS, writer);
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

