/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.xml.schematype;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.model.common.IValuedDefinition;
import gov.nist.secauto.metaschema.model.common.util.CollectionUtil;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.SchemaGenerationException;
import gov.nist.secauto.metaschema.schemagen.xml.XmlGenerationState;
import gov.nist.secauto.metaschema.schemagen.xml.schematype.AbstractXmlSimpleType;
import gov.nist.secauto.metaschema.schemagen.xml.schematype.IXmlSimpleType;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public class XmlSimpleTypeUnion
extends AbstractXmlSimpleType {
    @NonNull
    private final List<IXmlSimpleType> simpleTypes;

    public XmlSimpleTypeUnion(@NonNull QName qname, @NonNull IValuedDefinition definition, IXmlSimpleType ... simpleTypes) {
        super(qname, definition);
        this.simpleTypes = (List)CollectionUtil.requireNonEmpty((Collection)CollectionUtil.listOrEmpty((Object[])simpleTypes));
    }

    @NonNull
    public List<IXmlSimpleType> getSimpleTypes() {
        return this.simpleTypes;
    }

    @Override
    public void generateType(XmlGenerationState state, boolean anonymous) {
        try {
            state.writeStartElement("xs", "simpleType", "http://www.w3.org/2001/XMLSchema");
            if (!anonymous) {
                state.writeAttribute("name", (String)ObjectUtils.notNull((Object)this.getQName().getLocalPart()));
            }
            state.writeStartElement("xs", "union", "http://www.w3.org/2001/XMLSchema");
            LinkedList<IXmlSimpleType> memberTypes = new LinkedList<IXmlSimpleType>();
            LinkedList<IXmlSimpleType> inlineTypes = new LinkedList<IXmlSimpleType>();
            for (IXmlSimpleType unionType : this.simpleTypes) {
                if (unionType.isGeneratedType(state) && unionType.isInline(state)) {
                    inlineTypes.add(unionType);
                    continue;
                }
                memberTypes.add(unionType);
            }
            if (!memberTypes.isEmpty()) {
                state.writeAttribute("memberTypes", (String)ObjectUtils.notNull((Object)memberTypes.stream().map(type -> type.getTypeReference()).collect(Collectors.joining(" "))));
            }
            for (IXmlSimpleType inlineType : inlineTypes) {
                inlineType.generateType(state, true);
            }
            state.writeEndElement();
            state.writeEndElement();
            for (IXmlSimpleType memberType : memberTypes) {
                memberType.generateType(state, false);
            }
        }
        catch (XMLStreamException ex) {
            throw new SchemaGenerationException(ex);
        }
    }
}

