/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.model.testing;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.binding.io.Format;
import gov.nist.secauto.metaschema.binding.io.ISerializer;
import gov.nist.secauto.metaschema.codegen.binding.DynamicBindingContext;
import gov.nist.secauto.metaschema.model.MetaschemaLoader;
import gov.nist.secauto.metaschema.model.common.IMetaschema;
import gov.nist.secauto.metaschema.model.common.MetaschemaException;
import gov.nist.secauto.metaschema.model.common.util.ObjectUtils;
import gov.nist.secauto.metaschema.model.common.validation.IContentValidator;
import gov.nist.secauto.metaschema.model.common.validation.IValidationFinding;
import gov.nist.secauto.metaschema.model.common.validation.IValidationResult;
import gov.nist.secauto.metaschema.model.common.validation.JsonSchemaContentValidator;
import gov.nist.secauto.metaschema.model.testing.xmlbeans.ContentCaseType;
import gov.nist.secauto.metaschema.model.testing.xmlbeans.GenerateSchemaDocument;
import gov.nist.secauto.metaschema.model.testing.xmlbeans.MetaschemaDocument;
import gov.nist.secauto.metaschema.model.testing.xmlbeans.TestCollectionDocument;
import gov.nist.secauto.metaschema.model.testing.xmlbeans.TestScenarioDocument;
import gov.nist.secauto.metaschema.model.testing.xmlbeans.TestSuiteDocument;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicContainer;
import org.junit.jupiter.api.DynamicNode;
import org.junit.jupiter.api.DynamicTest;
import org.junit.platform.commons.JUnitException;

public abstract class AbstractTestSuite {
    private static final Logger LOGGER = LogManager.getLogger(AbstractTestSuite.class);
    private static final MetaschemaLoader LOADER = new MetaschemaLoader();
    private static final boolean DELETE_RESULTS_ON_EXIT = false;

    @NonNull
    protected abstract Format getRequiredContentFormat();

    @NonNull
    protected abstract URI getTestSuiteURI();

    @NonNull
    protected abstract Path getGenerationPath();

    @NonNull
    protected abstract BiFunction<IMetaschema, Writer, Void> getGeneratorSupplier();

    @Nullable
    protected abstract Supplier<? extends IContentValidator> getSchemaValidatorSupplier();

    @NonNull
    protected abstract Function<Path, ? extends IContentValidator> getContentValidatorSupplier();

    protected Stream<DynamicNode> testFactory() {
        try {
            return this.generateTests();
        }
        catch (IOException | XmlException ex) {
            throw new JUnitException("Unable to generate tests", ex);
        }
    }

    private Stream<DynamicNode> generateTests() throws XmlException, IOException {
        XmlOptions options = new XmlOptions();
        options.setBaseURI(null);
        options.setLoadLineNumbers();
        Path generationPath = this.getGenerationPath();
        if (Files.exists(generationPath, new LinkOption[0])) {
            if (!Files.isDirectory(generationPath, new LinkOption[0])) {
                throw new JUnitException(String.format("Generation path '%s' exists and is not a directory", generationPath));
            }
        } else {
            Files.createDirectories(generationPath, new FileAttribute[0]);
        }
        URI testSuiteUri = this.getTestSuiteURI();
        URL testSuiteUrl = testSuiteUri.toURL();
        TestSuiteDocument directive = (TestSuiteDocument)TestSuiteDocument.Factory.parse(testSuiteUrl, options);
        return directive.getTestSuite().getTestCollectionList().stream().flatMap(collection -> Stream.of(this.generateCollection((TestCollectionDocument.TestCollection)ObjectUtils.notNull((Object)collection), testSuiteUri, generationPath)));
    }

    protected void deleteCollectionOnExit(final Path path) {
        if (path != null) {
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                Files.delete(file);
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult postVisitDirectory(Path dir, IOException ex) throws IOException {
                                if (ex == null) {
                                    Files.delete(dir);
                                    return FileVisitResult.CONTINUE;
                                }
                                throw ex;
                            }
                        });
                    }
                    catch (IOException ex) {
                        throw new IllegalStateException("Failed to delete collection: " + path, ex);
                    }
                }
            }));
        }
    }

    private DynamicContainer generateCollection(@NonNull TestCollectionDocument.TestCollection collection, @NonNull URI testSuiteUri, @NonNull Path generationPath) {
        Path collectionGenerationPath;
        URI collectionUri = testSuiteUri.resolve(collection.getLocation());
        assert (collectionUri != null);
        LOGGER.atInfo().log("Collection: " + collectionUri);
        try {
            collectionGenerationPath = (Path)ObjectUtils.notNull((Object)Files.createTempDirectory(generationPath, "collection-", new FileAttribute[0]));
            assert (collectionGenerationPath != null);
        }
        catch (IOException ex) {
            throw new JUnitException("Unable to create collection temp directory", (Throwable)ex);
        }
        return DynamicContainer.dynamicContainer((String)collection.getName(), (URI)testSuiteUri, (Stream)((Stream)collection.getTestScenarioList().stream().flatMap(scenario -> {
            assert (scenario != null);
            return Stream.of(this.generateScenario((TestScenarioDocument.TestScenario)scenario, collectionUri, collectionGenerationPath));
        }).sequential()));
    }

    protected void produceSchema(@NonNull IMetaschema metaschema, @NonNull Path schemaPath) throws IOException {
        this.produceSchema(metaschema, schemaPath, this.getGeneratorSupplier());
    }

    protected void produceSchema(@NonNull IMetaschema metaschema, @NonNull Path schemaPath, @NonNull BiFunction<IMetaschema, Writer, Void> schemaProducer) throws IOException {
        Path parentDir = schemaPath.getParent();
        if (parentDir != null && !Files.exists(parentDir, new LinkOption[0])) {
            Files.createDirectories(parentDir, new FileAttribute[0]);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(schemaPath, StandardCharsets.UTF_8, this.getWriteOpenOptions());){
            schemaProducer.apply(metaschema, writer);
        }
    }

    protected OpenOption[] getWriteOpenOptions() {
        return new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING};
    }

    private DynamicContainer generateScenario(@NonNull TestScenarioDocument.TestScenario scenario, @NonNull URI collectionUri, @NonNull Path collectionGenerationPath) {
        Path scenarioGenerationPath;
        try {
            scenarioGenerationPath = Files.createTempDirectory(collectionGenerationPath, "scenario-", new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new JUnitException("Unable to create scenario temp directory", (Throwable)ex);
        }
        try {
            Files.createDirectories(scenarioGenerationPath, new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new JUnitException("Unable to create test directories for path: " + scenarioGenerationPath, (Throwable)ex);
        }
        GenerateSchemaDocument.GenerateSchema generateSchema = scenario.getGenerateSchema();
        MetaschemaDocument.Metaschema metaschemaDirective = generateSchema.getMetaschema();
        URI metaschemaUri = collectionUri.resolve(metaschemaDirective.getLocation());
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<IMetaschema> loadMetaschemaFuture = executor.submit(() -> {
            IMetaschema metaschema;
            try {
                metaschema = (IMetaschema)LOADER.load((URL)ObjectUtils.notNull((Object)metaschemaUri.toURL()));
            }
            catch (MetaschemaException | IOException ex) {
                throw new JUnitException("Unable to generate schema for Metaschema: " + metaschemaUri, ex);
            }
            return metaschema;
        });
        Future<Path> generateSchemaFuture = executor.submit(() -> {
            Path schemaPath;
            try {
                schemaPath = Files.createTempFile(scenarioGenerationPath, "", "-schema", new FileAttribute[0]);
            }
            catch (IOException ex) {
                throw new JUnitException("Unable to create schema temp file", (Throwable)ex);
            }
            IMetaschema metaschema = (IMetaschema)loadMetaschemaFuture.get();
            this.produceSchema((IMetaschema)ObjectUtils.notNull((Object)metaschema), (Path)ObjectUtils.notNull((Object)schemaPath));
            return schemaPath;
        });
        Future<DynamicBindingContext> dynamicBindingContextFuture = executor.submit(() -> {
            DynamicBindingContext context;
            IMetaschema metaschema = (IMetaschema)loadMetaschemaFuture.get();
            try {
                context = DynamicBindingContext.forMetaschema((IMetaschema)((IMetaschema)ObjectUtils.notNull((Object)metaschema)), (Path)((Path)ObjectUtils.notNull((Object)scenarioGenerationPath)));
            }
            catch (Exception ex) {
                throw new JUnitException("Unable to generate classes for metaschema: " + metaschemaUri, (Throwable)ex);
            }
            return context;
        });
        assert (dynamicBindingContextFuture != null);
        Future<IContentValidator> contentValidatorFuture = executor.submit(() -> {
            Path schemaPath = (Path)generateSchemaFuture.get();
            return this.getContentValidatorSupplier().apply(schemaPath);
        });
        assert (contentValidatorFuture != null);
        DynamicTest validateSchema = DynamicTest.dynamicTest((String)"Validate Schema", () -> {
            Supplier<? extends IContentValidator> supplier = this.getSchemaValidatorSupplier();
            if (supplier != null) {
                Path schemaPath;
                try {
                    schemaPath = (Path)ObjectUtils.requireNonNull((Object)((Path)generateSchemaFuture.get()));
                }
                catch (ExecutionException ex) {
                    throw new JUnitException("failed to generate schema", ex.getCause());
                }
                AbstractTestSuite.validate((IContentValidator)ObjectUtils.requireNonNull((Object)supplier.get()), schemaPath);
            }
        });
        Stream contentTests = (Stream)scenario.getValidationCaseList().stream().flatMap(contentCase -> {
            assert (contentCase != null);
            DynamicTest test = this.generateValidationCase((ContentCaseType)contentCase, dynamicBindingContextFuture, contentValidatorFuture, collectionUri, (Path)ObjectUtils.notNull((Object)scenarioGenerationPath));
            return test == null ? Stream.empty() : Stream.of(test);
        }).sequential();
        return DynamicContainer.dynamicContainer((String)scenario.getName(), (URI)metaschemaUri, (Stream)((Stream)Stream.concat(Stream.of(validateSchema), contentTests).sequential()));
    }

    protected Path convertContent(URI contentUri, @NonNull Path generationPath, @NonNull DynamicBindingContext context) throws IOException {
        Path convertedContetPath;
        Object object;
        try {
            object = context.newBoundLoader().load((URL)ObjectUtils.notNull((Object)contentUri.toURL()));
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
        if (!Files.exists(generationPath, new LinkOption[0])) {
            Files.createDirectories(generationPath, new FileAttribute[0]);
        }
        try {
            convertedContetPath = (Path)ObjectUtils.notNull((Object)Files.createTempFile(generationPath, "", "-content", new FileAttribute[0]));
        }
        catch (IOException ex) {
            throw new JUnitException("Unable to create schema temp file", (Throwable)ex);
        }
        ISerializer serializer = context.newSerializer(this.getRequiredContentFormat(), object.getClass());
        serializer.serialize(object, convertedContetPath, this.getWriteOpenOptions());
        return convertedContetPath;
    }

    private DynamicTest generateValidationCase(@NonNull ContentCaseType contentCase, @NonNull Future<DynamicBindingContext> contextFuture, @NonNull Future<IContentValidator> contentValidatorFuture, @NonNull URI collectionUri, @NonNull Path generationPath) {
        URI contentUri = collectionUri.resolve(contentCase.getLocation());
        Format format = contentCase.getSourceFormat();
        DynamicTest retval = null;
        if (this.getRequiredContentFormat().equals((Object)format)) {
            retval = DynamicTest.dynamicTest((String)String.format("Validate %s=%s: %s", format, contentCase.getValidationResult(), contentCase.getLocation()), (URI)contentUri, () -> {
                IContentValidator contentValidator;
                try {
                    contentValidator = (IContentValidator)contentValidatorFuture.get();
                }
                catch (ExecutionException ex) {
                    throw new JUnitException("failed to produce the content validator", ex.getCause());
                }
                Assertions.assertEquals((Object)contentCase.getValidationResult(), (Object)AbstractTestSuite.validate((IContentValidator)ObjectUtils.notNull((Object)contentValidator), (URL)ObjectUtils.notNull((Object)contentUri.toURL())), (String)"validation did not match expectation");
            });
        } else if (contentCase.getValidationResult().booleanValue()) {
            retval = DynamicTest.dynamicTest((String)String.format("Convert and Validate %s=%s: %s", format, contentCase.getValidationResult(), contentCase.getLocation()), (URI)contentUri, () -> {
                IContentValidator contentValidator;
                Path convertedContetPath;
                DynamicBindingContext context;
                try {
                    context = (DynamicBindingContext)contextFuture.get();
                }
                catch (ExecutionException ex) {
                    throw new JUnitException("failed to produce the content validator", ex.getCause());
                }
                assert (context != null);
                try {
                    convertedContetPath = this.convertContent(contentUri, generationPath, context);
                }
                catch (Exception ex) {
                    throw new JUnitException("failed to convert content: " + contentUri, (Throwable)ex);
                }
                try {
                    contentValidator = (IContentValidator)contentValidatorFuture.get();
                }
                catch (ExecutionException ex) {
                    throw new JUnitException("failed to produce the content validator", ex.getCause());
                }
                Assertions.assertEquals((Object)contentCase.getValidationResult(), (Object)AbstractTestSuite.validate((IContentValidator)ObjectUtils.notNull((Object)contentValidator), (URL)ObjectUtils.notNull((Object)convertedContetPath.toUri().toURL())), (String)String.format("validation of '%s' did not match expectation", convertedContetPath));
            });
        }
        return retval;
    }

    private static boolean validate(@NonNull IContentValidator validator, @NonNull URL target) throws IOException {
        IValidationResult schemaValidationResult;
        try {
            schemaValidationResult = validator.validate(target);
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
        return AbstractTestSuite.processValidationResult(schemaValidationResult);
    }

    protected static boolean validate(@NonNull IContentValidator validator, @NonNull Path target) throws IOException {
        IValidationResult schemaValidationResult = validator.validate(target);
        if (!schemaValidationResult.isPassing()) {
            LOGGER.atError().log("Schema validation failed for: {}", (Object)target);
        }
        return AbstractTestSuite.processValidationResult(schemaValidationResult);
    }

    private static boolean processValidationResult(IValidationResult schemaValidationResult) {
        for (IValidationFinding finding : schemaValidationResult.getFindings()) {
            AbstractTestSuite.logFinding((IValidationFinding)ObjectUtils.notNull((Object)finding));
        }
        return schemaValidationResult.isPassing();
    }

    private static void logFinding(@NonNull IValidationFinding finding) {
        LogBuilder logBuilder;
        switch (finding.getSeverity()) {
            case CRITICAL: {
                logBuilder = LOGGER.atFatal();
                break;
            }
            case ERROR: {
                logBuilder = LOGGER.atError();
                break;
            }
            case WARNING: {
                logBuilder = LOGGER.atWarn();
                break;
            }
            case INFORMATIONAL: {
                logBuilder = LOGGER.atInfo();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown level: " + finding.getSeverity().name());
            }
        }
        if (finding instanceof JsonSchemaContentValidator.JsonValidationFinding) {
            JsonSchemaContentValidator.JsonValidationFinding jsonFinding = (JsonSchemaContentValidator.JsonValidationFinding)finding;
            logBuilder.log("[{}] {}", (Object)jsonFinding.getCause().getPointerToViolation(), (Object)finding.getMessage());
        } else {
            logBuilder.log("{}", (Object)finding.getMessage());
        }
    }

    static {
        LOADER.allowEntityResolution();
    }
}

