/*
 * Decompiled with CFR 0.152.
 */
package gq.bxteam.ndailyrewards.cfg;

import gq.bxteam.ndailyrewards.NDailyRewards;
import gq.bxteam.ndailyrewards.cfg.JYML;
import gq.bxteam.ndailyrewards.cfg.MyConfig;
import gq.bxteam.ndailyrewards.data.DataType;
import gq.bxteam.ndailyrewards.gui.GUIItem;
import gq.bxteam.ndailyrewards.manager.RewardGUI;
import gq.bxteam.ndailyrewards.manager.objects.Reward;
import gq.bxteam.ndailyrewards.utils.logs.LogType;
import gq.bxteam.ndailyrewards.utils.logs.LogUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.bukkit.ChatColor;
import org.bukkit.inventory.ItemStack;

public class Config {
    private static MyConfig config;
    public static int data_save;
    public static DataType storage;
    public static String ms_login;
    public static String ms_pass;
    public static String ms_host;
    public static String ms_base;
    public static boolean ms_purge;
    public static int ms_purge_days;
    public static boolean opt_auto_is;
    public static boolean opt_auto_have;
    public static boolean opt_midnight;
    public static boolean cfgver;
    public static int opt_cd;
    public static int opt_days_row;
    public static Map<Integer, Reward> rewards;
    public static RewardGUI rewards_gui;

    public static void setup(MyConfig mc) {
        config = mc;
        JYML cfg = config.getConfig();
        cfg.addMissing("options.unlock-after-midnight", true);
        cfg.addMissing("options.rewards-cooldown", 86400);
        cfg.save();
        data_save = cfg.getInt("data.auto-save", 15);
        String path = "data.storage.";
        String m = cfg.getString(String.valueOf(path) + "type").toUpperCase();
        try {
            storage = DataType.valueOf(m);
        }
        catch (IllegalArgumentException ex) {
            storage = DataType.SQLITE;
            LogUtil.send("Unknown storage type: " + m + "! Switched to " + storage.getName(), LogType.WARN);
        }
        ms_login = cfg.getString(String.valueOf(path) + "username");
        ms_pass = cfg.getString(String.valueOf(path) + "password");
        ms_host = cfg.getString(String.valueOf(path) + "host");
        ms_base = cfg.getString(String.valueOf(path) + "database");
        path = "data.purge.";
        ms_purge = cfg.getBoolean(String.valueOf(path) + "enabled");
        ms_purge_days = cfg.getInt(String.valueOf(path) + "days", 60);
        path = "options.";
        opt_auto_is = cfg.getBoolean(String.valueOf(path) + "auto-open.enabled");
        opt_auto_have = cfg.getBoolean(String.valueOf(path) + "auto-open.only-when-have");
        opt_midnight = cfg.getBoolean(String.valueOf(path) + "unlock-after-midnight");
        opt_cd = cfg.getInt(String.valueOf(path) + "rewards-cooldown", 86400);
        opt_days_row = cfg.getInt(String.valueOf(path) + "days-row");
        cfgver = cfg.getBoolean(String.valueOf(path) + "cfgver");
        rewards = new TreeMap<Integer, Reward>();
        for (String d : cfg.getSection("rewards")) {
            int day = Integer.parseInt(d);
            List lore = cfg.getStringList("rewards." + d + ".lore");
            List cmd = cfg.getStringList("rewards." + d + ".commands");
            List msg = cfg.getStringList("rewards." + d + ".messages");
            Reward r = new Reward(day, lore, cmd, msg);
            rewards.put(day, r);
        }
        LogUtil.send("&eLoaded &6" + rewards.size() + " &edaily rewards!", LogType.INFO);
        path = "gui.";
        String g_title = ChatColor.translateAlternateColorCodes((char)'&', (String)cfg.getString(String.valueOf(path) + "title"));
        int g_size = cfg.getInt(String.valueOf(path) + "size");
        LinkedHashMap<String, GUIItem> g_items = new LinkedHashMap<String, GUIItem>();
        for (String id : cfg.getSection(String.valueOf(path) + "items")) {
            String path2 = String.valueOf(path) + "items." + id + ".";
            GUIItem gi = cfg.getGUIItemFromSection(path2);
            g_items.put(id, gi);
        }
        int[] slots = new int[]{0};
        if (cfg.contains(String.valueOf(path) + "days-positions")) {
            String[] raw = cfg.getString(String.valueOf(path) + "days-positions").replaceAll("\\s", "").split(",");
            slots = new int[raw.length];
            for (int i = 0; i < raw.length; ++i) {
                try {
                    slots[i] = Integer.parseInt(raw[i].trim());
                    continue;
                }
                catch (NumberFormatException gi) {
                    // empty catch block
                }
            }
        }
        ItemStack day_ready = cfg.getItemFromSection(String.valueOf(path) + "days-display.available");
        ItemStack day_taken = cfg.getItemFromSection(String.valueOf(path) + "days-display.taken");
        ItemStack day_locked = cfg.getItemFromSection(String.valueOf(path) + "days-display.locked");
        ItemStack day_next = cfg.getItemFromSection(String.valueOf(path) + "days-display.next");
        rewards_gui = new RewardGUI(NDailyRewards.getInstance(), g_title, g_size, g_items, slots, day_ready, day_taken, day_locked, day_next);
    }

    public static Reward getRewardByDay(int day) {
        if (rewards.containsKey(day)) {
            return rewards.get(day);
        }
        return null;
    }
}

