/*
 * Decompiled with CFR 0.152.
 */
package gq.bxteam.ndailyrewards.cfg;

import gq.bxteam.ndailyrewards.gui.ContentType;
import gq.bxteam.ndailyrewards.gui.GUIItem;
import gq.bxteam.ndailyrewards.utils.ArchUtils;
import gq.bxteam.ndailyrewards.utils.logs.LogType;
import gq.bxteam.ndailyrewards.utils.logs.LogUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class JYML
extends YamlConfiguration {
    private File f;

    public JYML(String path, String file) {
        this.f = new File(path, file);
        try {
            this.load(this.f);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        catch (InvalidConfigurationException e3) {
            e3.printStackTrace();
        }
    }

    public JYML(File f) {
        this.f = f;
        try {
            this.load(this.f);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        catch (InvalidConfigurationException e3) {
            e3.printStackTrace();
        }
    }

    public Set<String> getSection(String path) {
        if (!this.isConfigurationSection(path)) {
            return Collections.emptySet();
        }
        return this.getConfigurationSection(path).getKeys(false);
    }

    public static List<JYML> getFilesFolder(String path) {
        ArrayList<JYML> names = new ArrayList<JYML>();
        File folder = new File(path);
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles == null) {
            return names;
        }
        File[] array = listOfFiles;
        int length = listOfFiles.length;
        for (int i = 0; i < length; ++i) {
            File f = array[i];
            if (f.isFile()) {
                names.add(new JYML(f));
                continue;
            }
            if (!f.isDirectory()) continue;
            names.addAll(JYML.getFilesFolder(f.getPath()));
        }
        return names;
    }

    public ItemStack getItemFromSection(String path) {
        List flags;
        String mat;
        ItemStack item;
        if (!path.endsWith(".")) {
            path = String.valueOf(path) + ".";
        }
        if ((item = ArchUtils.buildItem(mat = this.getString(String.valueOf(path) + "material"))) == null) {
            LogUtil.send("Invalid item material on &f'" + path + "'! &c(" + this.f.getName() + ")", LogType.ERROR);
            return null;
        }
        String hash = this.getString(String.valueOf(path) + "skull-hash");
        if (hash != null) {
            String[] ss = path.split("\\.");
            String id = ss[ss.length - 1];
            item = ArchUtils.getHashed(item, hash, id);
        }
        ItemMeta meta = item.getItemMeta();
        String name = this.getString(String.valueOf(path) + "name");
        if (name != null) {
            meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
        }
        ArrayList<String> lore = new ArrayList<String>();
        for (Object s : this.getStringList(String.valueOf(path) + "lore")) {
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s));
        }
        meta.setLore(lore);
        if (this.getBoolean(String.valueOf(path) + "enchanted")) {
            meta.addEnchant(Enchantment.ARROW_DAMAGE, 1, true);
        }
        if ((flags = this.getStringList(String.valueOf(path) + "item-flags")).contains("*")) {
            meta.addItemFlags(ItemFlag.values());
        } else {
            for (String flag : flags) {
                try {
                    meta.addItemFlags(new ItemFlag[]{ItemFlag.valueOf((String)flag.toUpperCase())});
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        if (this.isSet(path + "custom-model-data")) {
            int customModelData = this.getInt(path + "custom-model-data");
            meta.setCustomModelData(Integer.valueOf(customModelData));
        }
        item.setItemMeta(meta);
        return item;
    }

    public GUIItem getGUIItemFromSection(String path) {
        ContentType type;
        ItemStack item;
        if (!path.endsWith(".")) {
            path = String.valueOf(path) + ".";
        }
        if ((item = this.getItemFromSection(path)) == null) {
            LogUtil.send("Invalid item material on &f'" + path + "'! &c(" + this.f.getName() + ")", LogType.ERROR);
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        meta.addItemFlags(ItemFlag.values());
        meta.setUnbreakable(true);
        item.setItemMeta(meta);
        int[] slots = new int[]{0};
        if (this.contains(String.valueOf(path) + "slots")) {
            String[] raw = this.getString(String.valueOf(path) + "slots").replaceAll("\\s", "").split(",");
            slots = new int[raw.length];
            for (int i = 0; i < raw.length; ++i) {
                try {
                    slots[i] = Integer.parseInt(raw[i].trim());
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        try {
            type = ContentType.valueOf(this.getString(String.valueOf(path) + "type", "NONE"));
        }
        catch (IllegalArgumentException ex) {
            type = ContentType.NONE;
        }
        String[] ss = path.split("\\.");
        String id = ss[ss.length - 1];
        if (id.isEmpty()) {
            id = String.valueOf(this.f.getName().replace(".yml", "")) + "-icon-" + ArchUtils.randInt(0, 3000);
        }
        GUIItem gi = new GUIItem(id, type, item, slots);
        return gi;
    }

    public void saveItemToSection(ItemStack item, String path) {
        String hash;
        if (item == null) {
            return;
        }
        if (!path.endsWith(".")) {
            path = String.valueOf(path) + ".";
        }
        Material m = item.getType();
        ItemMeta meta = item.getItemMeta();
        short data = item.getDurability();
        String mat = String.valueOf(m.name()) + ":" + data + ":" + item.getAmount();
        this.set(String.valueOf(path) + "material", mat);
        if (meta.hasDisplayName()) {
            this.set(String.valueOf(path) + "name", meta.getDisplayName());
        }
        if (meta.hasLore()) {
            this.set(String.valueOf(path) + "lore", meta.getLore());
        }
        if ((hash = ArchUtils.getHashOf(item)) != null && !hash.isEmpty()) {
            this.set(String.valueOf(path) + "skull-hash", hash);
        }
        if (meta.hasEnchants()) {
            this.set(String.valueOf(path) + "enchanted", true);
        }
        ArrayList<String> f2 = new ArrayList<String>();
        Set flags = meta.getItemFlags();
        for (ItemFlag f3 : flags) {
            f2.add(f3.name());
        }
        this.set(String.valueOf(path) + "item-flags", f2);
        this.set(String.valueOf(path) + "unbreakable", meta.isUnbreakable());
    }

    public void addMissing(String path, Object val) {
        if (this.contains(path)) {
            return;
        }
        this.set(path, val);
    }

    public File getFile() {
        return this.f;
    }

    public void save() {
        try {
            this.save(this.f);
        }
        catch (IOException e) {
            LogUtil.send("Unable to save config: &f" + this.f.getName() + "&7! &c(" + e.getMessage() + ")", LogType.ERROR);
        }
    }
}

