/*
 * Decompiled with CFR 0.152.
 */
package gq.bxteam.ndailyrewards.cmds;

import gq.bxteam.ndailyrewards.NDailyRewards;
import gq.bxteam.ndailyrewards.cmds.ICmd;
import gq.bxteam.ndailyrewards.cmds.list.HelpCommand;
import gq.bxteam.ndailyrewards.cmds.list.OpenCommand;
import gq.bxteam.ndailyrewards.cmds.list.ReloadCommand;
import gq.bxteam.ndailyrewards.utils.ArchUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;

public class CommandManager
implements CommandExecutor,
TabExecutor {
    private NDailyRewards plugin;
    private Map<String, ICmd> commands;
    private OpenCommand open;

    public CommandManager(NDailyRewards plugin) {
        this.plugin = plugin;
    }

    public void setup() {
        this.commands = new LinkedHashMap<String, ICmd>();
        this.open = new OpenCommand(this.plugin);
        this.register(this.open);
        this.register(new HelpCommand(this.plugin));
        this.register(new ReloadCommand(this.plugin));
    }

    public void shutdown() {
        this.commands.clear();
    }

    public void register(ICmd cmd) {
        this.commands.put(cmd.label(), cmd);
    }

    public Collection<ICmd> getCommands() {
        return this.commands.values();
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        ICmd command = this.open;
        if (args.length > 0 && this.commands.containsKey(args[0])) {
            command = this.commands.get(args[0]);
        }
        command.execute(sender, args);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return null;
        }
        if (args.length == 0) {
            return null;
        }
        if (args.length == 1) {
            ArrayList<String> sugg = new ArrayList<String>(this.commands.keySet());
            for (ICmd j : this.commands.values()) {
                if (j.hasPerm(sender)) continue;
                sugg.remove(j.label());
            }
            return ArchUtils.getSugg(args[0], sugg);
        }
        ICmd cb = this.commands.get(args[0]);
        if (cb == null) {
            return Collections.emptyList();
        }
        List<String> list = cb.getTab((Player)sender, args.length - 1, args);
        return ArchUtils.getSugg(args[args.length - 1], list);
    }
}

