/*
 * Decompiled with CFR 0.152.
 */
package gq.bxteam.ndailyrewards.cmds;

import gq.bxteam.ndailyrewards.NDailyRewards;
import gq.bxteam.ndailyrewards.cfg.Lang;
import gq.bxteam.ndailyrewards.utils.ArchUtils;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class ICmd {
    protected NDailyRewards plugin;

    public ICmd(NDailyRewards plugin) {
        this.plugin = plugin;
    }

    public abstract String label();

    public abstract String getPermission();

    public abstract boolean playersOnly();

    public abstract String usage();

    public List<String> getTab(Player p, int i, String[] args) {
        return Collections.emptyList();
    }

    public abstract void perform(CommandSender var1, String[] var2);

    public final void execute(CommandSender sender, String[] args) {
        if (this.playersOnly() && !(sender instanceof Player)) {
            return;
        }
        if (!this.hasPerm(sender)) {
            sender.sendMessage(String.valueOf(Lang.Prefix.toMsg()) + Lang.Error_NoPerm.toMsg());
            return;
        }
        this.perform(sender, args);
    }

    public boolean hasPerm(CommandSender sender) {
        if (this.getPermission() == null) {
            return true;
        }
        if (sender instanceof Player) {
            Player p = (Player)sender;
            return p.hasPermission(this.getPermission());
        }
        return true;
    }

    protected void printUsage(CommandSender sender) {
        sender.sendMessage(ArchUtils.oneSpace(String.valueOf(Lang.Prefix.toMsg()) + Lang.Commands_Help_Usage.toMsg().replace("%usage%", this.usage()).replace("%command%", this.label())));
    }

    protected void errPerm(CommandSender sender) {
        sender.sendMessage((Object)((Object)Lang.Prefix) + Lang.Error_NoPerm.toMsg());
    }

    protected void errPlayer(CommandSender sender) {
        sender.sendMessage((Object)((Object)Lang.Prefix) + Lang.Error_NoPlayer.toMsg());
    }

    protected void errSender(CommandSender sender) {
        sender.sendMessage((Object)((Object)Lang.Prefix) + Lang.Error_Console.toMsg());
    }

    protected double getNumD(CommandSender sender, String input, double def) {
        return this.getNumD(sender, input, def, false);
    }

    protected double getNumD(CommandSender sender, String input, double def, boolean allowNega) {
        try {
            double amount = Double.parseDouble(input);
            if (amount < 0.0 && !allowNega) {
                throw new NumberFormatException();
            }
            return amount;
        }
        catch (NumberFormatException ex) {
            sender.sendMessage((Object)((Object)Lang.Prefix) + Lang.Error_Number.toMsg().replace("%num%", input));
            return def;
        }
    }

    protected int getNumI(CommandSender sender, String input, int def) {
        return this.getNumI(sender, input, def, false);
    }

    protected int getNumI(CommandSender sender, String input, int def, boolean nega) {
        return (int)this.getNumD(sender, input, def, nega);
    }
}

