/*
 * Decompiled with CFR 0.152.
 */
package gq.bxteam.ndailyrewards.data;

import gq.bxteam.ndailyrewards.NDailyRewards;
import gq.bxteam.ndailyrewards.data.IDataV2;
import gq.bxteam.ndailyrewards.utils.logs.LogType;
import gq.bxteam.ndailyrewards.utils.logs.LogUtil;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.sqlite.JDBC;

public class D2SQLite
extends IDataV2 {
    private static D2SQLite instance = null;

    public static synchronized D2SQLite getInstance() throws SQLException {
        if (instance == null) {
            return new D2SQLite(NDailyRewards.getInstance());
        }
        return instance;
    }

    private D2SQLite(NDailyRewards plugin) throws SQLException {
        super(plugin);
        DriverManager.registerDriver(new JDBC());
    }

    @Override
    public void open() {
        try {
            this.con = DriverManager.getConnection("jdbc:sqlite:" + this.plugin.getDataFolder().getAbsolutePath() + "/data.db");
        }
        catch (SQLException e) {
            LogUtil.send(e.getMessage(), LogType.ERROR);
        }
    }

    @Override
    public void create() {
        String sql = "CREATE TABLE IF NOT EXISTS ndailyrewards_data ( uuid TEXT NOT NULL,\tname TEXT NOT NULL, login BIGINT NOT NULL, next BIGINT NOT NULL, expire BIGINT NOT NULL, day INTEGER NOT NULL, PRIMARY KEY (uuid));";
        try {
            this.con = this.getConnection();
            this.ps = this.con.createStatement();
            this.ps.execute("CREATE TABLE IF NOT EXISTS ndailyrewards_data ( uuid TEXT NOT NULL,\tname TEXT NOT NULL, login BIGINT NOT NULL, next BIGINT NOT NULL, expire BIGINT NOT NULL, day INTEGER NOT NULL, PRIMARY KEY (uuid));");
        }
        catch (SQLException e) {
            LogUtil.send(e.getMessage(), LogType.ERROR);
        }
        finally {
            try {
                this.con.close();
            }
            catch (SQLException sQLException) {}
            try {
                this.ps.close();
            }
            catch (SQLException sQLException) {}
        }
        try {
            this.con.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.ps.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

