/*
 * Decompiled with CFR 0.152.
 */
package gq.bxteam.ndailyrewards.data;

import gq.bxteam.ndailyrewards.NDailyRewards;
import gq.bxteam.ndailyrewards.cfg.Config;
import gq.bxteam.ndailyrewards.data.D2MySQL;
import gq.bxteam.ndailyrewards.data.D2SQLite;
import gq.bxteam.ndailyrewards.data.DataType;
import gq.bxteam.ndailyrewards.data.IDataV2;
import gq.bxteam.ndailyrewards.utils.logs.LogType;
import gq.bxteam.ndailyrewards.utils.logs.LogUtil;
import java.sql.SQLException;
import org.bukkit.plugin.Plugin;

public class DataManager {
    private NDailyRewards plugin;
    private IDataV2 data;

    public DataManager(NDailyRewards plugin) {
        this.plugin = plugin;
    }

    public void setup() {
        DataType d = Config.storage;
        switch (d) {
            case SQLITE: {
                try {
                    this.data = D2SQLite.getInstance();
                    break;
                }
                catch (SQLException e) {
                    LogUtil.send("Unable to connect to " + d.getName() + "!", LogType.ERROR);
                    LogUtil.send(e.getMessage(), LogType.ERROR);
                    this.plugin.getPluginManager().disablePlugin((Plugin)this.plugin);
                    return;
                }
            }
            case MYSQL: {
                try {
                    this.data = D2MySQL.getInstance();
                    break;
                }
                catch (SQLException e) {
                    LogUtil.send("Unable to connect to " + d.getName() + "!", LogType.ERROR);
                    LogUtil.send(e.getMessage(), LogType.ERROR);
                    this.plugin.getPluginManager().disablePlugin((Plugin)this.plugin);
                    return;
                }
            }
        }
        LogUtil.send("Storage type: &f" + d.getName(), LogType.INFO);
        this.data.open();
        this.data.create();
        this.data.purge();
    }

    public void shutdown() {
        this.data.close();
    }

    public IDataV2 getData() {
        return this.data;
    }
}

