/*
 * Decompiled with CFR 0.152.
 */
package gq.bxteam.ndailyrewards.data;

import gq.bxteam.ndailyrewards.NDailyRewards;
import gq.bxteam.ndailyrewards.cfg.Config;
import gq.bxteam.ndailyrewards.manager.objects.DUser;
import gq.bxteam.ndailyrewards.utils.logs.LogType;
import gq.bxteam.ndailyrewards.utils.logs.LogUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public abstract class IDataV2 {
    protected NDailyRewards plugin;
    protected final String table = "ndailyrewards_data";
    protected Connection con;
    protected Statement ps;
    protected ResultSet rs;

    public IDataV2(NDailyRewards plugin) {
        this.plugin = plugin;
    }

    public abstract void create();

    public abstract void open();

    public Connection getConnection() {
        try {
            if (this.con == null || this.con.isClosed()) {
                this.open();
            }
        }
        catch (SQLException ex) {
            this.open();
        }
        return this.con;
    }

    public void close() {
        try {
            if (this.con != null) {
                this.con.close();
            }
            if (this.ps != null) {
                this.ps.close();
            }
            if (this.rs != null) {
                this.rs.close();
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            try {
                if (this.con != null) {
                    this.con.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (this.ps != null) {
                    this.ps.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (this.rs != null) {
                    this.rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        try {
            if (this.con != null) {
                this.con.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (this.ps != null) {
                this.ps.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (this.rs != null) {
                this.rs.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void exec(String sql) {
        try {
            this.con = this.getConnection();
            this.ps = this.con.prepareStatement(sql);
            ((PreparedStatement)this.ps).executeUpdate();
        }
        catch (SQLException e) {
            LogUtil.send(e.getMessage(), LogType.ERROR);
        }
        finally {
            try {
                if (this.ps != null) {
                    this.ps.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (this.rs != null) {
                    this.rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        try {
            if (this.ps != null) {
                this.ps.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (this.rs != null) {
                this.rs.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasColumn(String table, String columnName) {
        try {
            this.con = this.getConnection();
            this.ps = this.con.createStatement();
            String sql = "SELECT * FROM " + table;
            this.rs = this.ps.executeQuery(sql);
            ResultSetMetaData rsmd = this.rs.getMetaData();
            int columns = rsmd.getColumnCount();
            for (int x = 1; x <= columns; ++x) {
                if (!columnName.equals(rsmd.getColumnName(x))) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            LogUtil.send(e.getMessage(), LogType.ERROR);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (this.ps != null) {
                    this.ps.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (this.rs != null) {
                    this.rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public void purge() {
        if (!Config.ms_purge) {
            return;
        }
        int i = 0;
        for (DUser l : this.getUsers()) {
            long log = l.getLastLogin();
            long log2 = System.currentTimeMillis() - log;
            int days = (int)(log2 / 86400000L % 7L);
            if (days < Config.ms_purge_days) continue;
            this.del(l.getUUID());
            ++i;
        }
        LogUtil.send("Data purge: Purged &f" + i + " &7inactive users.", LogType.INFO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DUser> getUsers() {
        ArrayList<DUser> list = new ArrayList<DUser>();
        String sql = "SELECT * FROM ndailyrewards_data";
        try {
            Object uuid;
            this.con = this.getConnection();
            this.ps = this.con.createStatement();
            this.rs = this.ps.executeQuery("SELECT * FROM ndailyrewards_data");
            while (this.rs.next()) {
                uuid = this.rs.getString("uuid");
                String name = this.rs.getString("name");
                long login = this.rs.getLong("login");
                int day = this.rs.getInt("day");
                long next = this.rs.getLong("next");
                long expire = this.rs.getLong("expire");
                list.add(new DUser((String)uuid, name, login, day, next, expire));
            }
            uuid = list;
            return uuid;
        }
        catch (SQLException e) {
            LogUtil.send("Unable to get all players from database!", LogType.ERROR);
            LogUtil.send(e.getMessage(), LogType.ERROR);
            ArrayList<DUser> arrayList = list;
            return arrayList;
        }
        finally {
            try {
                if (this.ps != null) {
                    this.ps.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (this.rs != null) {
                    this.rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DUser getByUUID(String uuid) {
        String sql = "SELECT * FROM ndailyrewards_data WHERE `uuid` = ?";
        try {
            this.con = this.getConnection();
            this.ps = this.con.prepareStatement("SELECT * FROM ndailyrewards_data WHERE `uuid` = ?");
            ((PreparedStatement)this.ps).setString(1, uuid);
            this.rs = ((PreparedStatement)this.ps).executeQuery();
            if (this.rs.next()) {
                String uuid2 = this.rs.getString("uuid");
                String name2 = this.rs.getString("name");
                long login = this.rs.getLong("login");
                int day = this.rs.getInt("day");
                long next = this.rs.getLong("next");
                long expire = this.rs.getLong("expire");
                DUser dUser = new DUser(uuid2, name2, login, day, next, expire);
                return dUser;
            }
            DUser uuid2 = null;
            return uuid2;
        }
        catch (SQLException e) {
            LogUtil.send(e.getMessage(), LogType.ERROR);
            DUser dUser = null;
            return dUser;
        }
        finally {
            try {
                if (this.ps != null) {
                    this.ps.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (this.rs != null) {
                    this.rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public boolean isExists(String uuid) {
        return this.getByUUID(uuid) != null;
    }

    public void save(DUser mp) {
        String uuid = mp.getUUID();
        long date = mp.getLastLogin();
        int day = mp.getDayInRow();
        long next = mp.getNextRewardTime();
        long expire = mp.getTimeToGetReward();
        String sql = "UPDATE ndailyrewards_data SET `login` = '" + date + "', `next` = '" + next + "', `expire` = '" + expire + "', `day` = '" + day + "' WHERE `uuid` = '" + uuid + "'";
        this.exec(sql);
    }

    public void add(DUser mp) {
        if (this.isExists(mp.getUUID())) {
            return;
        }
        String uid = mp.getUUID();
        String name = mp.getName();
        long date = System.currentTimeMillis();
        int day = mp.getDayInRow();
        long next = mp.getNextRewardTime();
        long expire = mp.getTimeToGetReward();
        String sql = "INSERT INTO ndailyrewards_data(`uuid`, `name`, `login`, `next`, `expire`, `day`) VALUES('" + uid + "', '" + name + "', '" + date + "', '" + next + "', '" + expire + "', '" + day + "')";
        this.exec(sql);
    }

    public void del(String uuid) {
        String sql = "DELETE FROM ndailyrewards_data WHERE `uuid` = '" + uuid + "'";
        this.exec(sql);
    }
}

