/*
 * Decompiled with CFR 0.152.
 */
package gq.bxteam.ndailyrewards.gui;

import gq.bxteam.ndailyrewards.AbstractListener;
import gq.bxteam.ndailyrewards.NDailyRewards;
import gq.bxteam.ndailyrewards.gui.ContentType;
import gq.bxteam.ndailyrewards.gui.GUIItem;
import gq.bxteam.ndailyrewards.gui.GUIUtils;
import java.util.LinkedHashMap;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public abstract class GUI
extends AbstractListener<NDailyRewards>
implements InventoryHolder {
    private UUID uuid = UUID.randomUUID();
    protected String title;
    protected int size;
    protected LinkedHashMap<String, GUIItem> items;

    public GUI(NDailyRewards plugin, String title, int size, LinkedHashMap<String, GUIItem> items) {
        super(plugin);
        this.setTitle(title);
        this.setSize(size);
        LinkedHashMap<String, GUIItem> map = new LinkedHashMap<String, GUIItem>();
        for (GUIItem gi : items.values()) {
            map.put(gi.getId(), new GUIItem(gi));
        }
        this.items = map;
        this.registerListeners();
    }

    public void shutdown() {
        this.unregisterListeners();
    }

    public UUID getUUID() {
        return this.uuid;
    }

    protected ItemStack getItem(Inventory inv, int slot) {
        ItemStack i = inv.getItem(slot);
        if (i == null) {
            return new ItemStack(Material.AIR);
        }
        return new ItemStack(i);
    }

    public final Inventory getInventory() {
        return ((NDailyRewards)this.plugin).getServer().createInventory((InventoryHolder)this, this.getSize(), this.getTitle());
    }

    public void open(Player p) {
        p.openInventory(this.addDefaults());
    }

    protected boolean ignoreNullClick() {
        return true;
    }

    protected final Inventory addDefaults() {
        Inventory inv = this.getInventory();
        for (GUIItem gi : this.getContent().values()) {
            for (int slot : gi.getSlots()) {
                inv.setItem(slot, gi.getItem());
            }
        }
        return inv;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public LinkedHashMap<String, GUIItem> getContent() {
        return this.items;
    }

    public boolean click(Player p, ItemStack item, ContentType type, int slot, InventoryClickEvent e) {
        if (type == ContentType.EXIT) {
            p.closeInventory();
            return false;
        }
        return true;
    }

    public boolean onClose(Player p, InventoryCloseEvent e) {
        return true;
    }

    @EventHandler(ignoreCancelled=true)
    public void onClick(InventoryClickEvent e) {
        InventoryHolder ih = e.getInventory().getHolder();
        if (ih == null || !ih.getClass().isInstance(this)) {
            return;
        }
        e.setCancelled(true);
        GUI g = (GUI)ih;
        if (!g.getUUID().equals(this.uuid)) {
            return;
        }
        ItemStack item = e.getCurrentItem();
        if (this.ignoreNullClick() && (item == null || item.getType() == Material.AIR)) {
            return;
        }
        this.click((Player)e.getWhoClicked(), item, GUIUtils.getItemType(item), e.getRawSlot(), e);
    }

    @EventHandler
    public void onClose(InventoryCloseEvent e) {
        InventoryHolder ih = e.getInventory().getHolder();
        if (ih == null || !ih.getClass().isInstance(this)) {
            return;
        }
        GUI g = (GUI)ih;
        if (!g.getUUID().equals(this.uuid)) {
            return;
        }
        this.onClose((Player)e.getPlayer(), e);
    }
}

