/*
 * Decompiled with CFR 0.152.
 */
package gq.bxteam.ndailyrewards.gui;

import gq.bxteam.ndailyrewards.NDailyRewards;
import gq.bxteam.ndailyrewards.gui.ContentType;
import gq.bxteam.ndailyrewards.gui.GUI;
import gq.bxteam.ndailyrewards.gui.GUIItem;
import gq.bxteam.ndailyrewards.gui.GUIUtils;
import java.util.LinkedHashMap;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public abstract class Pageable
extends GUI {
    protected int pages;

    public Pageable(NDailyRewards plugin, String title, int size, LinkedHashMap<String, GUIItem> items, int pages) {
        super(plugin, title, size, items);
        this.pages = pages;
    }

    public final int getPages() {
        return this.pages;
    }

    @Override
    public boolean click(Player p, ItemStack item, ContentType type, int slot, InventoryClickEvent e) {
        if (!super.click(p, item, type, slot, e)) {
            return false;
        }
        if (type == ContentType.NEXT) {
            int page = GUIUtils.getPage(item);
            this.open(p, page);
            return false;
        }
        if (type == ContentType.BACK) {
            int page = GUIUtils.getPage(item);
            this.open(p, page);
            return false;
        }
        return true;
    }

    public abstract void open(Player var1, int var2);

    @Override
    public final void open(Player p) {
        this.open(p, 1);
    }

    protected Inventory addDefaults(int page) {
        Inventory inv = this.getInventory();
        for (GUIItem gi : this.getContent().values()) {
            ItemStack item = gi.getItem().clone();
            if (gi.getType() == ContentType.NEXT) {
                if (this.pages <= 1 || page >= this.pages) continue;
                item = GUIUtils.setPage(item, page + 1);
            }
            if (gi.getType() == ContentType.BACK) {
                if (page <= 1) continue;
                item = GUIUtils.setPage(item, page - 1);
            }
            for (int slot : gi.getSlots()) {
                inv.setItem(slot, item);
            }
        }
        return inv;
    }
}

