/*
 * Decompiled with CFR 0.152.
 */
package gq.bxteam.ndailyrewards.manager;

import gq.bxteam.ndailyrewards.NDailyRewards;
import gq.bxteam.ndailyrewards.cfg.Config;
import gq.bxteam.ndailyrewards.gui.ContentType;
import gq.bxteam.ndailyrewards.gui.GUI;
import gq.bxteam.ndailyrewards.gui.GUIItem;
import gq.bxteam.ndailyrewards.gui.GUIUtils;
import gq.bxteam.ndailyrewards.manager.objects.DUser;
import gq.bxteam.ndailyrewards.manager.objects.Reward;
import gq.bxteam.ndailyrewards.utils.ArchUtils;
import gq.bxteam.ndailyrewards.utils.logs.LogType;
import gq.bxteam.ndailyrewards.utils.logs.LogUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class RewardGUI
extends GUI {
    private int[] day_slots;
    private ItemStack day_ready;
    private ItemStack day_taken;
    private ItemStack day_locked;
    private ItemStack day_next;
    private Set<Player> opens;

    public RewardGUI(NDailyRewards plugin, String title, int size, LinkedHashMap<String, GUIItem> items, int[] day_slots, ItemStack day_ready, ItemStack day_taken, ItemStack day_locked, ItemStack day_next) {
        super(plugin, title, size, items);
        this.day_slots = day_slots;
        this.day_ready = day_ready;
        this.day_taken = day_taken;
        this.day_locked = day_locked;
        this.day_next = day_next;
        this.start();
    }

    public void start() {
        this.opens = new HashSet<Player>();
        ((NDailyRewards)this.plugin).getServer().getScheduler().scheduleSyncRepeatingTask(this.plugin, new Runnable(){

            @Override
            public void run() {
                for (Player p : new ArrayList(RewardGUI.this.opens)) {
                    RewardGUI.this.open(p);
                }
            }
        }, 0L, 20L);
    }

    @Override
    public void open(Player p) {
        p.openInventory(this.build(p));
    }

    private Inventory build(Player p) {
        Inventory inv = this.getInventory();
        DUser user = ((NDailyRewards)this.plugin).getUserManager().getOrLoadUser(p);
        for (GUIItem gi : this.getContent().values()) {
            for (int slot : gi.getSlots()) {
                ItemStack item = new ItemStack(gi.getItem());
                this.replaceLore(item, user.getDayInRow(), user, user.getNextRewardTime());
                inv.setItem(slot, item);
            }
        }
        int user_day = user.getDayInRow();
        for (int i = 0; i < this.day_slots.length; ++i) {
            int day2 = i + 1;
            int slot2 = this.day_slots[i];
            long time = user.getNextRewardTime();
            ItemStack icon = user_day == day2 ? (user.hasActiveReward() ? new ItemStack(this.day_ready) : new ItemStack(this.day_next)) : (user_day > day2 ? new ItemStack(this.day_taken) : new ItemStack(this.day_locked));
            this.replaceLore(icon, day2, user, time);
            icon = GUIUtils.setPage(icon, day2);
            inv.setItem(slot2, icon);
        }
        return inv;
    }

    private void replaceLore(ItemStack icon, int day2, DUser user, long time) {
        ItemMeta meta = icon.getItemMeta();
        if (meta.hasDisplayName()) {
            String n = meta.getDisplayName().replace("%day%", String.valueOf(day2));
            meta.setDisplayName(n);
        }
        if (meta.hasLore()) {
            Reward rewa = Config.getRewardByDay(day2);
            if (rewa == null) {
                LogUtil.send("&cError! Not found reward for &f" + day2 + "th day!", LogType.ERROR);
                return;
            }
            ArrayList<String> lore = new ArrayList<String>();
            for (String s : meta.getLore()) {
                if (System.currentTimeMillis() > time) {
                    time = System.currentTimeMillis();
                }
                if (s.equalsIgnoreCase("%reward-lore%")) {
                    for (String s2 : rewa.getLore()) {
                        lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s2.replace("%day%", String.valueOf(day2))));
                    }
                    continue;
                }
                s = ChatColor.translateAlternateColorCodes((char)'&', (String)s);
                s = s.replace("%expire%", ArchUtils.getTimeLeft(user.getTimeToGetReward())).replace("%time%", ArchUtils.getTimeLeft(time)).replace("%day%", String.valueOf(day2));
                lore.add(s);
            }
            meta.setLore(lore);
        }
        icon.setItemMeta(meta);
    }

    @EventHandler
    public void onOpen(InventoryOpenEvent e) {
        if (e.getInventory().getHolder() instanceof RewardGUI) {
            this.opens.add((Player)e.getPlayer());
        }
    }

    @Override
    public boolean onClose(Player p, InventoryCloseEvent e) {
        this.opens.remove(p);
        return false;
    }

    @Override
    public boolean click(Player p, ItemStack item, ContentType type, int slot, InventoryClickEvent e) {
        if (type == ContentType.EXIT) {
            p.closeInventory();
            return false;
        }
        int day = GUIUtils.getPage(item);
        DUser user = ((NDailyRewards)this.plugin).getUserManager().getOrLoadUser(p);
        if (user.getDayInRow() == day && user.hasActiveReward()) {
            Reward r = Config.getRewardByDay(day);
            if (r == null) {
                LogUtil.send("&cError! Not found reward for &f" + day + "th day!", LogType.ERROR);
                return false;
            }
            r.give(p);
            user.takeReward();
            this.open(p);
        }
        return true;
    }
}

