/*
 * Decompiled with CFR 0.152.
 */
package gq.bxteam.ndailyrewards.manager;

import gq.bxteam.ndailyrewards.AbstractListener;
import gq.bxteam.ndailyrewards.NDailyRewards;
import gq.bxteam.ndailyrewards.cfg.Config;
import gq.bxteam.ndailyrewards.data.DataType;
import gq.bxteam.ndailyrewards.manager.objects.DUser;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.scheduler.BukkitRunnable;

public class UserManager
extends AbstractListener<NDailyRewards> {
    private Map<String, DUser> users;
    private Set<DUser> save = new HashSet<DUser>();

    public UserManager(NDailyRewards plugin) {
        super(plugin);
    }

    public void setup() {
        this.users = new HashMap<String, DUser>();
        for (Player p : ((NDailyRewards)this.plugin).getServer().getOnlinePlayers()) {
            this.getOrLoadUser(p);
        }
        this.registerListeners();
    }

    public void shutdown() {
        this.autosave();
        this.users.clear();
        this.save.clear();
        this.unregisterListeners();
    }

    public void autosave() {
        for (DUser cu : this.save) {
            ((NDailyRewards)this.plugin).getData().save(cu);
        }
        this.save.clear();
        for (DUser cu : this.getUsers()) {
            ((NDailyRewards)this.plugin).getData().save(cu);
            this.users.put(cu.getUUID(), cu);
        }
    }

    public DUser getOrLoadUser(Player p) {
        String uuid = p.getUniqueId().toString();
        if (this.users.containsKey(uuid)) {
            return this.users.get(uuid);
        }
        for (DUser cu : this.save) {
            if (!cu.getUUID().equalsIgnoreCase(uuid)) continue;
            this.save.remove(cu);
            this.users.put(uuid, cu);
            return cu;
        }
        DUser user = ((NDailyRewards)this.plugin).getData().getByUUID(uuid);
        if (user != null) {
            this.users.put(uuid, user);
            return user;
        }
        user = new DUser(p);
        ((NDailyRewards)this.plugin).getData().add(user);
        this.users.put(uuid, user);
        return user;
    }

    public void unloadUser(Player p) {
        String ui = p.getUniqueId().toString();
        if (this.users.containsKey(ui)) {
            final DUser user = this.users.get(ui);
            user.setLastLogin(System.currentTimeMillis());
            if (Config.storage == DataType.MYSQL) {
                new BukkitRunnable(){

                    public void run() {
                        ((NDailyRewards)UserManager.this.plugin).getData().save(user);
                    }
                }.runTaskAsynchronously(this.plugin);
            } else {
                this.save.add(user);
            }
            this.users.remove(ui);
        }
    }

    public Collection<DUser> getUsers() {
        return this.users.values();
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        final Player p = e.getPlayer();
        DUser user = this.getOrLoadUser(p);
        user.updateRewards();
        if (Config.opt_auto_is && (!Config.opt_auto_have || Config.opt_auto_have && user.hasActiveReward())) {
            new BukkitRunnable(){

                public void run() {
                    Config.rewards_gui.open(p);
                }
            }.runTaskLater(this.plugin, 10L);
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        Player p = e.getPlayer();
        this.unloadUser(p);
    }
}

