/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 
 // out is a ByteArrayOutputStream put in scope by
 // JsLintMojo
printToOut = function(s){
    out.println(s);
};

(function (a) {
    readFile = function( file ) {
        var jq = new java.io.File(file);
        var reader = new java.io.BufferedReader(new java.io.FileReader(jq));
        var line = null;
        var lines = [];
        var readFileIndex = 0;
        for(readFileIndex; (line = reader.readLine()) != null; readFileIndex++) {
            lines[readFileIndex] = line+"\n";
        }
        return lines;
    };
    JSLINT(readFile(sourceFilePath));
    if(reportJslintErrorsOnly+"" == "true"){
        for (var i = 0; i < JSLINT.errors.length; i += 1) {
            var e = JSLINT.errors[i];
            if (e) {
                printToOut('Lint at line ' + (e.line + 1) + ' character ' +
                        (e.character + 1) + ': ' + e.reason);
                printToOut((e.evidence || '').
                        replace(/^\s*(\S*(\s+\S+)*)\s*$/, "$1"));
                printToOut('');
            }
        }
    }
    else{
        printToOut(JSLINT.report());
    }
})();