/*
 * Decompiled with CFR 0.152.
 */
package gr.ekt.bteio.generators;

import au.com.bytecode.opencsv.CSVWriter;
import gr.ekt.bte.core.DataOutputSpec;
import gr.ekt.bte.core.OutputGenerator;
import gr.ekt.bte.core.Record;
import gr.ekt.bte.core.RecordSet;
import gr.ekt.bte.core.Value;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class CSVOutputGenerator
implements OutputGenerator {
    private List<String> fields_;
    private CSVWriter writer_;
    private static Logger logger_ = Logger.getLogger(CSVOutputGenerator.class);

    public CSVOutputGenerator(String filename, List<String> fields) throws FileNotFoundException, IOException {
        this.writer_ = new CSVWriter((Writer)new FileWriter(filename));
        this.fields_ = fields;
    }

    public List<String> generateOutput(RecordSet record_set) {
        for (Record rec : record_set) {
            String[] line = new String[this.fields_.size()];
            for (int i = 0; i < this.fields_.size(); ++i) {
                List vals = rec.getValues(this.fields_.get(i));
                if (vals == null || vals.size() == 0) continue;
                String val = "";
                for (int j = 0; j < vals.size(); ++j) {
                    val = val + ((Value)vals.get(j)).getAsString();
                    if (j == vals.size() - 1) break;
                    val = val + "||";
                }
                line[i] = val;
            }
            this.writer_.writeNext(line);
        }
        try {
            this.writer_.flush();
        }
        catch (IOException e) {
            logger_.info((Object)e.getMessage());
        }
        return new ArrayList<String>();
    }

    public List<String> generateOutput(RecordSet record_set, DataOutputSpec spec) {
        return this.generateOutput(record_set);
    }
}

