/*
 * Decompiled with CFR 0.152.
 */
package gr.ekt.bteio.generators;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonStreamParser;
import gr.ekt.bte.core.DataOutputSpec;
import gr.ekt.bte.core.OutputGenerator;
import gr.ekt.bte.core.Record;
import gr.ekt.bte.core.RecordSet;
import gr.ekt.bte.core.Value;
import gr.ekt.bteio.specs.DSpaceOutputSpec;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.log4j.Logger;

public class DSpaceOutputGenerator
implements OutputGenerator {
    private Map<String, String> field_map_;
    private DSpaceOutputSpec spec_;
    private String output_directory_ = "./output";
    private int padding_ = 5;
    private boolean write_json_;
    private int directory_cnt_ = 0;
    private Logger logger_ = Logger.getLogger(DSpaceOutputGenerator.class);

    public DSpaceOutputGenerator(Map<String, String> fmap) {
        this.field_map_ = fmap;
        this.spec_ = null;
    }

    public DSpaceOutputGenerator(Map<String, String> fmap, DSpaceOutputSpec spec) {
        this.field_map_ = fmap;
        this.spec_ = spec;
    }

    public List<String> generateOutput(RecordSet recs) {
        List<String> ret = null;
        ret = this.spec_ != null ? this.createOutput(recs, this.spec_.getPrefixDir(), this.spec_.getPadding()) : this.createOutput(recs, this.output_directory_, this.padding_);
        if (this.write_json_) {
            this.writeJsonToFile(ret, "./output.json");
        }
        return ret;
    }

    public List<String> generateOutput(RecordSet recs, DataOutputSpec spec) {
        this.spec_ = (DSpaceOutputSpec)spec;
        return this.generateOutput(recs);
    }

    public void writeOutput(List<String> output) {
        for (String rec : output) {
            JsonObject dir;
            String path;
            File dir_path;
            JsonStreamParser jsp = new JsonStreamParser(rec);
            JsonObject top_level_object = jsp.next().getAsJsonObject();
            String dir_prefix = top_level_object.get("dir_prefix").getAsString();
            File parent_dir = new File(dir_prefix);
            if (!parent_dir.exists()) {
                parent_dir.mkdir();
            }
            if (!(dir_path = new File(path = (dir = top_level_object.getAsJsonObject("directory")).getAsJsonPrimitive("path").getAsString())).exists()) {
                dir_path.mkdir();
            }
            JsonArray files = dir.getAsJsonArray("files");
            for (JsonElement file : files) {
                JsonArray data;
                JsonObject file_object = file.getAsJsonObject();
                String filename = file_object.getAsJsonPrimitive("name").getAsString();
                String abs_filename = path + File.separator + filename;
                PrintWriter file_writer = null;
                try {
                    file_writer = new PrintWriter(new File(abs_filename));
                }
                catch (FileNotFoundException e) {
                    this.logger_.debug((Object)("Cannot open file " + abs_filename));
                    continue;
                }
                if (filename.equals("contents")) {
                    data = file_object.getAsJsonArray("data");
                    for (JsonElement contents : data) {
                        file_writer.println(contents.getAsJsonPrimitive().getAsString());
                    }
                } else if (filename.equals("collections")) {
                    data = file_object.getAsJsonArray("data");
                    for (JsonElement collections : data) {
                        file_writer.println(collections.getAsJsonPrimitive().getAsString());
                    }
                } else if (filename.equals("handle")) {
                    data = file_object.getAsJsonPrimitive("data");
                    file_writer.println(data.getAsString());
                } else {
                    file_writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                    file_writer.println("<dublin_core schema='" + file_object.getAsJsonPrimitive("schema").getAsString() + "'>");
                    data = file_object.getAsJsonArray("data");
                    for (JsonElement dc_value : data) {
                        JsonObject value_object = dc_value.getAsJsonObject().getAsJsonObject("dcvalue");
                        String line = "  <dcvalue ";
                        line = line + "namespace='" + value_object.getAsJsonPrimitive("namespace").getAsString() + "' ";
                        line = line + "element='" + value_object.getAsJsonPrimitive("element").getAsString() + "'";
                        if (value_object.has("qualifier")) {
                            line = line + " qualifier='" + value_object.getAsJsonPrimitive("qualifier").getAsString() + "'";
                        }
                        line = line + ">" + StringEscapeUtils.escapeXml((String)value_object.getAsJsonPrimitive("value").getAsString()) + "</dcvalue>";
                        file_writer.println(line);
                    }
                    file_writer.println("</dublin_core>");
                }
                file_writer.close();
            }
        }
    }

    private List<String> createOutput(RecordSet records, String dir_prefix, int padding) {
        ArrayList<String> ret = new ArrayList<String>();
        HashMap<String, List<String>> namespace_fields = new HashMap<String, List<String>>();
        for (String key : this.field_map_.keySet()) {
            String[] elems = key.split("\\.");
            if (elems.length == 1) {
                if (elems[0].equals("handle") || elems[0].equals("contents") || elems[0].equals("collections")) continue;
                this.logger_.debug((Object)("Field \"" + key + "\" is not a valid dspace field name. Ignoring"));
                continue;
            }
            if (!namespace_fields.containsKey(elems[0])) {
                namespace_fields.put(elems[0], new ArrayList());
            }
            ((List)namespace_fields.get(elems[0])).add(key);
        }
        String format_string = "%0" + padding + "d";
        String parent_dir = this.sanitize(dir_prefix);
        for (Record rec : records) {
            String elem = "{\"dir_prefix\": \"" + parent_dir + "\", ";
            ++this.directory_cnt_;
            String output_directory = dir_prefix + File.separator + String.format(format_string, this.directory_cnt_) + File.separator;
            this.logger_.debug((Object)("Outdir = " + output_directory));
            elem = elem + "\"directory\": {\"path\": \"" + this.sanitize(output_directory) + "\", ";
            elem = elem + "\"files\":[";
            List<String> file_json = this.prepareFilesJSONRepresentation(namespace_fields, rec);
            if (file_json.size() > 0) {
                for (int i = 0; i < file_json.size(); ++i) {
                    elem = elem + file_json.get(i);
                    if (i >= file_json.size() - 1) continue;
                    elem = elem + ", ";
                }
            }
            elem = elem + "]";
            elem = elem + "}";
            elem = elem + "}";
            ret.add(elem);
        }
        return ret;
    }

    private List<String> prepareFilesJSONRepresentation(Map<String, List<String>> namespace_fields, Record rec) {
        Value val;
        Iterator val_it;
        List contents;
        String json_file;
        ArrayList<String> ret = new ArrayList<String>();
        Iterator<String> ns_it = namespace_fields.keySet().iterator();
        while (ns_it.hasNext()) {
            json_file = "";
            String cns = ns_it.next();
            String filename = cns.equals("dc") ? "dublin_core.xml" : "metadata_" + cns + ".xml";
            json_file = json_file + "{\"name\": \"" + this.sanitize(filename) + "\", \"schema\": \"" + this.sanitize(cns) + "\", \"data\":[";
            List<String> file_data = this.prepareFileDataJSONRepresentation(namespace_fields.get(cns), rec);
            if (file_data.size() == 0) continue;
            for (int i = 0; i < file_data.size(); ++i) {
                json_file = json_file + file_data.get(i);
                if (i >= file_data.size() - 1) continue;
                json_file = json_file + ", ";
            }
            json_file = json_file + "]";
            json_file = json_file + "}";
            ret.add(json_file);
        }
        json_file = "{\"name\": \"contents\", \"data\":[";
        if (this.field_map_.containsKey("contents") && (contents = rec.getValues(this.field_map_.get("contents"))) != null) {
            val_it = contents.iterator();
            while (val_it.hasNext()) {
                val = (Value)val_it.next();
                json_file = json_file + "\"" + this.sanitize(val.getAsString()) + "\"";
                if (!val_it.hasNext()) continue;
                json_file = json_file + ", ";
            }
        }
        json_file = json_file + "]";
        json_file = json_file + "}";
        ret.add(json_file);
        if (this.field_map_.containsKey("handle")) {
            json_file = "{\"name\": \"handle\", \"data\": \"";
            List handle_list = rec.getValues(this.field_map_.get("handle"));
            String handle = "";
            if (handle_list != null && handle_list.size() > 0) {
                Value handle_value = (Value)handle_list.get(0);
                handle = handle_value.getAsString();
            }
            json_file = json_file + this.sanitize(handle);
            json_file = json_file + "\"}";
            ret.add(json_file);
        }
        if (this.field_map_.containsKey("collections")) {
            json_file = "{\"name\": \"collections\", \"data\":[";
            List collection_list = rec.getValues(this.field_map_.get("collections"));
            if (collection_list != null) {
                val_it = collection_list.iterator();
                while (val_it.hasNext()) {
                    val = (Value)val_it.next();
                    json_file = json_file + "\"" + this.sanitize(val.getAsString()) + "\"";
                    if (!val_it.hasNext()) continue;
                    json_file = json_file + ", ";
                }
            }
            json_file = json_file + "]";
            json_file = json_file + "}";
            ret.add(json_file);
        }
        return ret;
    }

    private List<String> prepareFileDataJSONRepresentation(List<String> field_list, Record rec) {
        ArrayList<String> ret = new ArrayList<String>();
        String[] titles = new String[]{"namespace", "element", "qualifier"};
        for (int i = 0; i < field_list.size(); ++i) {
            String rec_field;
            String field = field_list.get(i);
            String[] field_elems = field.split("\\.");
            if (field_elems.length < 2 || field_elems.length > 3) {
                // empty if block
            }
            if ((rec_field = this.field_map_.get(field)) == null) {
                this.logger_.debug((Object)("Field " + field + " not found in field map"));
                continue;
            }
            List value_list = rec.getValues(rec_field);
            if (value_list == null || value_list.size() == 0) {
                this.logger_.debug((Object)("Field " + field + " has no values"));
                continue;
            }
            for (int j = 0; j < value_list.size(); ++j) {
                Value val = (Value)value_list.get(j);
                if (val.getAsString().equals("")) {
                    this.logger_.debug((Object)"Empty value, not writing");
                    continue;
                }
                String json_value = "{\"dcvalue\": {";
                for (int idx = 0; idx < field_elems.length; ++idx) {
                    json_value = json_value + "\"" + titles[idx] + "\": \"" + field_elems[idx] + "\", ";
                }
                json_value = json_value + "\"value\": \"" + this.sanitize(val.getAsString()) + "\"";
                json_value = json_value + "}}";
                ret.add(json_value);
            }
        }
        return ret;
    }

    private String sanitize(String inp) {
        String ret = inp;
        int pfi = 0;
        int fi = ret.indexOf(92);
        while (fi != -1) {
            if (fi == ret.length() - 1) {
                ret = ret + "\\";
                break;
            }
            if (ret.charAt(fi + 1) == '\\') {
                fi = ret.indexOf(92, fi + 2);
                continue;
            }
            String prefix = ret.substring(pfi, fi);
            String suffix = ret.substring(fi + 1);
            ret = prefix + "\\\\" + suffix;
            fi = ret.indexOf(92, prefix.length() + 2);
        }
        ret = ret.replaceAll("\\n", "\\\\n");
        ret = ret.replaceAll("\\f", "\\\\f");
        ret = ret.replaceAll("\\r", "\\\\r");
        ret = ret.replaceAll("\\t", "\\\\t");
        ret = ret.replaceAll("\\\"", "\\\\\"");
        return ret;
    }

    public DSpaceOutputSpec getSpec() {
        return this.spec_;
    }

    public void setSpec(DSpaceOutputSpec spec_) {
        this.spec_ = spec_;
    }

    public void setFieldMap(Map<String, String> fmap) {
        this.field_map_ = fmap;
    }

    public Map<String, String> getFieldMap() {
        return this.field_map_;
    }

    private void writeJsonToFile(List<String> json, String filename) {
        try {
            PrintWriter pw = new PrintWriter(new File(filename));
            pw.println("[");
            System.out.println("size = " + json.size());
            for (int i = 0; i < json.size(); ++i) {
                pw.print(json.get(i));
                if (i >= json.size() - 1) continue;
                pw.println(",");
            }
            pw.println("]");
            pw.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public String getOutputDirectory() {
        return this.output_directory_;
    }

    public void setOutputDirectory(String output_directory_) {
        this.output_directory_ = output_directory_;
    }

    public boolean getWriteJSON() {
        return this.write_json_;
    }

    public void setWriteJSON(boolean write_json_) {
        this.write_json_ = write_json_;
    }

    public int getDirectoryCounter() {
        return this.directory_cnt_;
    }

    public void setDirectoryCounter(int directory_cnt_) {
        this.directory_cnt_ = directory_cnt_;
    }
}

