/*
 * Decompiled with CFR 0.152.
 */
package gr.ekt.bteio.loaders;

import gr.ekt.bte.core.DataLoadingSpec;
import gr.ekt.bte.core.Record;
import gr.ekt.bte.core.RecordSet;
import gr.ekt.bte.core.StringValue;
import gr.ekt.bte.dataloader.FileDataLoader;
import gr.ekt.bte.exceptions.EmptySourceException;
import gr.ekt.bte.exceptions.MalformedSourceException;
import gr.ekt.bte.record.MapRecord;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jbibtex.BibTeXDatabase;
import org.jbibtex.BibTeXEntry;
import org.jbibtex.BibTeXParser;
import org.jbibtex.BibTeXString;
import org.jbibtex.Key;
import org.jbibtex.ParseException;
import org.jbibtex.Value;

public class BibTeXDataLoader
extends FileDataLoader {
    private static Logger logger_ = Logger.getLogger(BibTeXDataLoader.class);
    private Map<String, String> field_map_;
    private FileReader reader_;

    public BibTeXDataLoader() {
        this.field_map_ = null;
        this.reader_ = null;
    }

    public BibTeXDataLoader(String filename, Map<String, String> fields) throws EmptySourceException {
        super(filename);
        this.field_map_ = fields;
        try {
            this.reader_ = new FileReader(new File(filename));
        }
        catch (IOException e) {
            logger_.info((Object)("Problem loading file: " + filename));
            throw new EmptySourceException("Problem loading file: " + filename);
        }
    }

    public RecordSet getRecords() throws MalformedSourceException {
        BibTeXDatabase bibtex_entries = null;
        try {
            bibtex_entries = this.loadFile();
        }
        catch (IOException e) {
            logger_.info((Object)("Problem loading file: " + this.filename));
            throw new MalformedSourceException("Problem loading file: " + this.filename);
        }
        catch (ParseException e) {
            logger_.info((Object)("Bad input file: " + this.filename));
            throw new MalformedSourceException("Bad input file: " + this.filename);
        }
        if (bibtex_entries == null) {
            logger_.debug((Object)("Unknown error while reading file: " + this.filename));
            throw new EmptySourceException("Unknown error while reading file: " + this.filename);
        }
        RecordSet ret = new RecordSet();
        Collection entries = bibtex_entries.getEntries().values();
        for (BibTeXEntry entry : entries) {
            MapRecord rec = new MapRecord();
            for (Map.Entry<String, String> en : this.field_map_.entrySet()) {
                ArrayList<StringValue> vals;
                String record_key = en.getValue();
                Key key = new Key(en.getKey());
                Value bib_value = entry.getField(key);
                if (bib_value == null) continue;
                String latexString = bib_value.toUserString();
                if (rec.hasField(record_key)) {
                    vals = rec.getValues(record_key);
                    vals.add(new StringValue(latexString));
                    rec.updateField(record_key, vals);
                    continue;
                }
                vals = new ArrayList<StringValue>();
                vals.add(new StringValue(latexString));
                rec.addField(record_key, vals);
            }
            ret.addRecord((Record)rec);
        }
        return ret;
    }

    public RecordSet getRecords(DataLoadingSpec spec) throws MalformedSourceException {
        return this.getRecords();
    }

    protected void finalize() throws Throwable {
        this.reader_.close();
    }

    private BibTeXDatabase loadFile() throws IOException, ParseException, EmptySourceException {
        if (this.reader_ == null) {
            throw new EmptySourceException("Input file is not open");
        }
        BibTeXParser parser = new BibTeXParser(){

            public void checkStringResolution(Key key, BibTeXString string) {
                if (string == null) {
                    logger_.debug((Object)("Unresolved string: \"" + key.getValue() + "\""));
                }
            }

            public void checkCrossReferenceResolution(Key key, BibTeXEntry entry) {
                if (entry == null) {
                    logger_.debug((Object)("Unresolved cross-reference: \"" + key.getValue() + "\""));
                }
            }
        };
        return parser.parse((Reader)this.reader_);
    }

    public Map<String, String> getFieldMap() {
        return this.field_map_;
    }

    public void setFieldMap(Map<String, String> field_map_) {
        this.field_map_ = field_map_;
    }

    public void setFilename(String filename) {
        this.filename = filename;
        try {
            this.reader_ = new FileReader(new File(filename));
        }
        catch (IOException e) {
            logger_.info((Object)("Problem loading file: " + filename));
            this.reader_ = null;
        }
    }
}

