/*
 * Decompiled with CFR 0.152.
 */
package gr.ekt.bteio.loaders;

import au.com.bytecode.opencsv.CSVReader;
import gr.ekt.bte.core.DataLoadingSpec;
import gr.ekt.bte.core.Record;
import gr.ekt.bte.core.RecordSet;
import gr.ekt.bte.core.StringValue;
import gr.ekt.bte.core.Value;
import gr.ekt.bte.dataloader.FileDataLoader;
import gr.ekt.bte.exceptions.EmptySourceException;
import gr.ekt.bte.exceptions.MalformedSourceException;
import gr.ekt.bte.record.MapRecord;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.apache.log4j.Logger;

public class CSVDataLoader
extends FileDataLoader {
    private static Logger logger_ = Logger.getLogger(CSVDataLoader.class);
    private CSVReader reader_;
    private Map<Integer, String> field_map_;
    private int skip_lines_ = 0;
    private char separator_ = (char)44;
    private char quote_char_ = (char)34;
    private String value_separator_ = null;

    public CSVDataLoader() {
        this.reader_ = null;
        this.field_map_ = null;
    }

    public CSVDataLoader(String filename, Map<Integer, String> fields) {
        super(filename);
        this.field_map_ = fields;
    }

    public CSVDataLoader(String filename, Map<Integer, String> fields, char separator, char quote_char, int skip_lines, String value_separator) {
        super(filename);
        this.field_map_ = fields;
        this.separator_ = separator;
        this.quote_char_ = quote_char;
        this.skip_lines_ = skip_lines;
        this.value_separator_ = value_separator;
    }

    public RecordSet getRecords() throws MalformedSourceException, EmptySourceException {
        this.openReader();
        if (this.reader_ == null) {
            throw new EmptySourceException("Input file is not open");
        }
        RecordSet rs = null;
        try {
            String[] next_line;
            rs = new RecordSet();
            while ((next_line = this.reader_.readNext()) != null) {
                MapRecord rec = new MapRecord();
                for (Map.Entry<Integer, String> en : this.field_map_.entrySet()) {
                    int i = en.getKey();
                    if (next_line.length <= i) {
                        throw new MalformedSourceException("The requested column " + i + " does not exist");
                    }
                    if (this.value_separator_ != null) {
                        String[] values = next_line[i].split(this.value_separator_);
                        for (int j = 0; j < values.length; ++j) {
                            rec.addValue(this.field_map_.get(i), (Value)new StringValue(values[j]));
                        }
                        continue;
                    }
                    rec.addValue(this.field_map_.get(i), (Value)new StringValue(next_line[i]));
                }
                rs.addRecord((Record)rec);
            }
        }
        catch (IOException e) {
            logger_.info((Object)e.getMessage());
            throw new MalformedSourceException("");
        }
        return rs;
    }

    public RecordSet getRecords(DataLoadingSpec spec) throws MalformedSourceException {
        if (spec.getOffset() > 0) {
            return new RecordSet();
        }
        return this.getRecords();
    }

    protected void finalize() throws Throwable {
        this.reader_.close();
    }

    private void openReader() throws EmptySourceException {
        try {
            this.reader_ = new CSVReader((Reader)new FileReader(this.filename), this.separator_, this.quote_char_, this.skip_lines_);
        }
        catch (FileNotFoundException e) {
            throw new EmptySourceException("File " + this.filename + " not found");
        }
    }

    public void setFilename(String filename) {
        this.filename = filename;
        try {
            this.openReader();
        }
        catch (EmptySourceException e) {
            logger_.info((Object)("Could not open file " + filename));
            this.reader_ = null;
        }
    }

    public Map<Integer, String> getFieldMap() {
        return this.field_map_;
    }

    public void setFieldMap(Map<Integer, String> fields_) {
        this.field_map_ = fields_;
    }

    public int getSkipLines() {
        return this.skip_lines_;
    }

    public void setSkipLines(int skip_lines_) {
        this.skip_lines_ = skip_lines_;
    }

    public char getSeparator() {
        return this.separator_;
    }

    public void setSeparator(char separator_) {
        this.separator_ = separator_;
    }

    public char getQuoteChar() {
        return this.quote_char_;
    }

    public void setQuoteChar(char quote_char_) {
        this.quote_char_ = quote_char_;
    }

    public String getValueSeparator() {
        return this.value_separator_;
    }

    public void setValueSeparator(String value_separator_) {
        this.value_separator_ = value_separator_;
    }
}

