/*
 * Decompiled with CFR 0.152.
 */
package gr.ekt.bteio.loaders;

import gr.ekt.bte.core.DataLoadingSpec;
import gr.ekt.bte.core.Record;
import gr.ekt.bte.core.RecordSet;
import gr.ekt.bte.core.StringValue;
import gr.ekt.bte.core.Value;
import gr.ekt.bte.dataloader.FileDataLoader;
import gr.ekt.bte.exceptions.EmptySourceException;
import gr.ekt.bte.exceptions.MalformedSourceException;
import gr.ekt.bte.record.MapRecord;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class EndnoteDataLoader
extends FileDataLoader {
    private static Logger logger_ = Logger.getLogger(EndnoteDataLoader.class);
    private BufferedReader reader_;
    private Map<String, String> field_map_;

    public EndnoteDataLoader() {
        this.reader_ = null;
        this.field_map_ = null;
    }

    public EndnoteDataLoader(String filename, Map<String, String> field_map) throws EmptySourceException {
        super(filename);
        this.field_map_ = field_map;
        this.openReader();
    }

    public RecordSet getRecords() throws MalformedSourceException {
        if (this.reader_ == null) {
            throw new EmptySourceException("File " + this.filename + " could not be opened");
        }
        RecordSet ret = new RecordSet();
        try {
            String line = this.reader_.readLine();
            if (line == null) {
                return ret;
            }
            if (!line.startsWith("FN")) {
                throw new MalformedSourceException("File " + this.filename + " is not a valid Endnote file: First line does not contain \"FN\" tag.");
            }
            line = this.reader_.readLine();
            if (!line.startsWith("VR")) {
                throw new MalformedSourceException("File " + this.filename + " is not a valid Endnote file: Second line does not contain \"VR\" tag.");
            }
            MapRecord current_record = new MapRecord();
            Pattern endnote_pattern = Pattern.compile("(^[A-Z]{2}) ?(.*)$");
            String current_value = null;
            String current_tag = null;
            String current_field = null;
            int line_no = 2;
            while ((line = this.reader_.readLine()) != null) {
                ++line_no;
                if ((line = line.trim()).isEmpty() || line.equals("")) continue;
                Matcher endnote_matcher = endnote_pattern.matcher(line);
                if (endnote_matcher.matches()) {
                    current_tag = endnote_matcher.group(1);
                    if (current_tag.equals("ER")) {
                        ret.addRecord((Record)current_record);
                        current_record = new MapRecord();
                        current_value = null;
                        current_tag = null;
                        current_field = null;
                        continue;
                    }
                    if (current_tag.equals("EF")) break;
                    current_field = this.field_map_.get(current_tag);
                    current_value = endnote_matcher.group(2);
                } else {
                    current_value = line;
                }
                if (current_field == null && current_tag == null) {
                    logger_.debug((Object)("Parse error on line " + line_no + ": Tag expected\n" + line));
                    throw new MalformedSourceException("Parse error on line " + line_no + ": Tag expected\n" + line);
                }
                if (current_value == null) {
                    logger_.debug((Object)("Parse error on line " + line_no + ": Value expected."));
                    throw new MalformedSourceException("Parse error on line " + line_no + ": Value expected.");
                }
                if (current_field == null) continue;
                current_record.addValue(current_field, (Value)new StringValue(current_value));
            }
        }
        catch (IOException e) {
            logger_.info((Object)("Error while reading from file " + this.filename));
            throw new MalformedSourceException("Error while reading from file " + this.filename);
        }
        return ret;
    }

    public RecordSet getRecords(DataLoadingSpec spec) throws MalformedSourceException {
        return this.getRecords();
    }

    public void setFilename(String filename) {
        this.filename = filename;
        try {
            this.openReader();
        }
        catch (EmptySourceException e) {
            logger_.info((Object)("Could not open file " + filename));
            this.reader_ = null;
        }
    }

    protected void finalize() throws Throwable {
        this.reader_.close();
    }

    private void openReader() throws EmptySourceException {
        try {
            this.reader_ = new BufferedReader(new FileReader(this.filename));
        }
        catch (FileNotFoundException e) {
            throw new EmptySourceException("File " + this.filename + " not found");
        }
    }

    public Map<String, String> getFieldMap() {
        return this.field_map_;
    }

    public void setFieldMap(Map<String, String> field_map_) {
        this.field_map_ = field_map_;
    }
}

