/*
 * Decompiled with CFR 0.152.
 */
package gr.ekt.bteio.loaders;

import gr.ekt.bte.core.DataLoadingSpec;
import gr.ekt.bte.core.Record;
import gr.ekt.bte.core.RecordSet;
import gr.ekt.bte.core.StringValue;
import gr.ekt.bte.core.Value;
import gr.ekt.bte.dataloader.FileDataLoader;
import gr.ekt.bte.exceptions.MalformedSourceException;
import gr.ekt.bte.record.MapRecord;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelDataLoader
extends FileDataLoader {
    private static Logger logger_ = Logger.getLogger(ExcelDataLoader.class);
    private Workbook wb_;
    private Map<Integer, String> fieldMap_;
    private int skipLines_;
    private int ignoreLinesAfter_;
    private boolean isRead_;

    public ExcelDataLoader(String filename, Map<Integer, String> fieldMap) {
        super(filename);
        new File(filename);
        this.fieldMap_ = fieldMap;
        this.skipLines_ = 0;
        this.ignoreLinesAfter_ = 0;
        this.wb_ = null;
        this.isRead_ = false;
    }

    public RecordSet getRecords() throws MalformedSourceException {
        try {
            this.openReader();
        }
        catch (IOException e) {
            logger_.info((Object)("Problem loading file: " + this.filename + " (" + e.getMessage() + ")"));
            throw new MalformedSourceException("Problem loading file: " + this.filename + " (" + e.getMessage() + ")");
        }
        catch (InvalidFormatException e) {
            logger_.info((Object)("Problem loading file: " + this.filename + " (" + e.getMessage() + ")"));
            throw new MalformedSourceException("Problem loading file: " + this.filename + " (" + e.getMessage() + ")");
        }
        RecordSet ret = new RecordSet();
        if (!this.isRead_) {
            logger_.info((Object)("Opening file: " + this.filename));
            int nSheets = this.wb_.getNumberOfSheets();
            logger_.info((Object)("number of sheets: " + nSheets));
            for (int i = 0; i < nSheets; ++i) {
                Sheet cSheet = this.wb_.getSheetAt(i);
                String cSheetName = cSheet.getSheetName();
                for (int j = this.skipLines_; j <= cSheet.getLastRowNum() && (this.ignoreLinesAfter_ == 0 || j < this.ignoreLinesAfter_); ++j) {
                    Row row = cSheet.getRow(j);
                    MapRecord rec = new MapRecord();
                    for (int k = 0; k < row.getLastCellNum(); ++k) {
                        StringValue val;
                        Cell cCell;
                        if (!this.fieldMap_.keySet().contains(k) || (cCell = row.getCell(k)) == null) continue;
                        int cellType = cCell.getCellType();
                        switch (cellType) {
                            case 1: {
                                val = new StringValue(cCell.getStringCellValue());
                                break;
                            }
                            case 0: {
                                if (DateUtil.isCellDateFormatted((Cell)cCell)) {
                                    SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
                                    val = new StringValue(sdf.format(cCell.getDateCellValue()));
                                    break;
                                }
                                val = new StringValue(String.valueOf(cCell.getNumericCellValue()));
                                break;
                            }
                            case 3: {
                                val = new StringValue("");
                                break;
                            }
                            case 4: {
                                val = new StringValue(String.valueOf(cCell.getBooleanCellValue()));
                                break;
                            }
                            default: {
                                val = new StringValue("Unsupported cell type");
                            }
                        }
                        rec.addValue(this.fieldMap_.get(k), (Value)val);
                    }
                    rec.addValue("ExcelSheetName", (Value)new StringValue(cSheetName));
                    ret.addRecord((Record)rec);
                }
            }
            this.isRead_ = true;
        }
        return ret;
    }

    public RecordSet getRecords(DataLoadingSpec spec) throws MalformedSourceException {
        return this.getRecords();
    }

    private void openReader() throws IOException, InvalidFormatException {
        this.wb_ = WorkbookFactory.create((File)new File(this.filename));
    }

    public Map<Integer, String> getFieldMap() {
        return this.fieldMap_;
    }

    public void setFieldMap(Map<Integer, String> fieldMap) {
        this.fieldMap_ = fieldMap;
    }

    public int getSkipLines() {
        return this.skipLines_;
    }

    public void setSkipLines(int skipLines) {
        this.skipLines_ = skipLines;
    }

    public int getIgnoreLinesAfter() {
        return this.ignoreLinesAfter_;
    }

    public void setIgnoreLinesAfter(int ignoreLinesAfter) {
        this.ignoreLinesAfter_ = ignoreLinesAfter;
    }
}

