/*
 * Decompiled with CFR 0.152.
 */
package gr.ekt.bteio.loaders;

import gr.ekt.bte.core.DataLoader;
import gr.ekt.bte.core.DataLoadingSpec;
import gr.ekt.bte.core.RecordSet;
import gr.ekt.bte.core.StringValue;
import gr.ekt.bte.core.Value;
import gr.ekt.bte.exceptions.MalformedSourceException;
import gr.ekt.bte.record.MapRecord;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import se.kb.oai.OAIException;
import se.kb.oai.pmh.OaiPmhServer;
import se.kb.oai.pmh.Record;
import se.kb.oai.pmh.RecordsList;
import se.kb.oai.pmh.ResumptionToken;

public class OAIPMHDataLoader
implements DataLoader {
    private static Logger logger_;
    private OaiPmhServer server_;
    private String server_address_;
    private ResumptionToken token_;
    private String prefix_;
    private boolean has_more_records_;
    private Map<String, String> field_map_;

    public OAIPMHDataLoader() {
        this.server_ = null;
        this.server_address_ = null;
        this.token_ = null;
        this.prefix_ = null;
        this.has_more_records_ = true;
        this.field_map_ = null;
    }

    public OAIPMHDataLoader(String server_address, String prefix, Map<String, String> field_map) {
        this.server_address_ = server_address;
        this.server_ = new OaiPmhServer(this.server_address_);
        this.has_more_records_ = true;
        this.prefix_ = prefix;
        this.field_map_ = field_map;
    }

    public RecordSet getRecords() throws MalformedSourceException {
        if (this.server_ == null) {
            throw new MalformedSourceException("Connection with server " + this.server_address_ + " has not been established");
        }
        RecordSet ret = new RecordSet();
        if (!this.has_more_records_) {
            return ret;
        }
        try {
            RecordsList records = null;
            records = this.token_ == null ? this.server_.listRecords(this.prefix_) : this.server_.listRecords(this.token_);
            List oai_record_list = records.asList();
            this.token_ = records.getResumptionToken();
            this.has_more_records_ = this.token_ != null;
            for (int i = 0; i < oai_record_list.size(); ++i) {
                gr.ekt.bte.core.Record rec = this.oai2bte((Record)oai_record_list.get(i));
                ret.addRecord(rec);
            }
        }
        catch (OAIException e) {
            logger_.info((Object)("Caught OAIException " + e.getMessage()));
            throw new MalformedSourceException(e.getMessage());
        }
        return ret;
    }

    public RecordSet getRecords(DataLoadingSpec spec) throws MalformedSourceException {
        if (spec.getIdentifier() != null) {
            if (this.server_ == null) {
                throw new MalformedSourceException("Connection with server " + this.server_address_ + " has not been established");
            }
            RecordSet ret = new RecordSet();
            try {
                Record oai_record = this.server_.getRecord(spec.getIdentifier(), this.prefix_);
                gr.ekt.bte.core.Record rec = this.oai2bte(oai_record);
                ret.addRecord(rec);
            }
            catch (OAIException e) {
                logger_.info((Object)("Caught OAIException " + e.getMessage()));
                throw new MalformedSourceException(e.getMessage());
            }
            return ret;
        }
        return this.getRecords();
    }

    public String getServerAddress() {
        return this.server_address_;
    }

    public void setServerAddress(String server_address_) {
        this.server_address_ = server_address_;
        this.server_ = new OaiPmhServer(server_address_);
        this.has_more_records_ = true;
    }

    public String getPrefix() {
        return this.prefix_;
    }

    public void setPrefix(String prefix_) {
        this.prefix_ = prefix_;
    }

    private gr.ekt.bte.core.Record oai2bte(Record oai_record) {
        MapRecord rec = new MapRecord();
        Element metadata_element = oai_record.getMetadata();
        for (String field : this.field_map_.keySet()) {
            String record_key = this.field_map_.get(field);
            for (Object elem : metadata_element.elements(field)) {
                String field_value = ((Element)elem).getText();
                rec.addValue(record_key, (Value)new StringValue(field_value));
            }
        }
        return rec;
    }

    public Map<String, String> getFieldMap() {
        return this.field_map_;
    }

    public void setFieldMap(Map<String, String> field_map_) {
        this.field_map_ = field_map_;
    }
}

