/*
 * Decompiled with CFR 0.152.
 */
package gr.ekt.bteio.loaders;

import gr.ekt.bte.core.DataLoadingSpec;
import gr.ekt.bte.core.RecordSet;
import gr.ekt.bte.core.StringValue;
import gr.ekt.bte.core.Value;
import gr.ekt.bte.dataloader.FileDataLoader;
import gr.ekt.bte.exceptions.EmptySourceException;
import gr.ekt.bte.exceptions.MalformedSourceException;
import gr.ekt.bte.record.MapRecord;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class RISDataLoader
extends FileDataLoader {
    private static Logger logger_ = Logger.getLogger(RISDataLoader.class);
    private BufferedReader reader_;
    private Map<String, String> field_map_;

    public RISDataLoader() {
        this.reader_ = null;
        this.field_map_ = null;
    }

    public RISDataLoader(String filename, Map<String, String> field_map) throws EmptySourceException {
        super(filename);
        this.field_map_ = field_map;
        this.openReader();
    }

    public RecordSet getRecords() throws MalformedSourceException {
        if (this.reader_ == null) {
            throw new EmptySourceException("Input file is not open");
        }
        RecordSet records = new RecordSet();
        try {
            String line;
            boolean in_record = false;
            int line_cnt = 0;
            MapRecord rec = null;
            String ris_tag = null;
            while ((line = this.reader_.readLine()) != null) {
                String field;
                StringValue val;
                ++line_cnt;
                if (line.isEmpty() || line.equals("") || line.matches("^\\s*$")) continue;
                Pattern ris_pattern = Pattern.compile("^([A-Z][A-Z0-9])  - (.*)$");
                Matcher ris_matcher = ris_pattern.matcher(line);
                if (ris_matcher.matches()) {
                    ris_tag = ris_matcher.group(1);
                    if (!in_record) {
                        if (ris_tag.equals("TY")) {
                            in_record = true;
                            rec = new MapRecord();
                        } else {
                            logger_.debug((Object)("Line: " + line_cnt + " in file " + this.filename + " should contain tag \"TY\""));
                            throw new MalformedSourceException("Line: " + line_cnt + " in file " + this.filename + " should contain tag \"TY\"");
                        }
                    }
                    if (ris_tag.equals("ER")) {
                        in_record = false;
                        records.addRecord(rec);
                        rec = null;
                        continue;
                    }
                    if (!this.field_map_.containsKey(ris_tag)) {
                        logger_.warn((Object)("Tag \"" + ris_tag + "\" is not in the field map. Ignoring"));
                        continue;
                    }
                    val = new StringValue(ris_matcher.group(2));
                } else {
                    val = new StringValue(line);
                }
                if ((field = this.field_map_.get(ris_tag)) == null) continue;
                rec.addValue(field, (Value)val);
            }
        }
        catch (IOException e) {
            logger_.info((Object)("Error while reading from file " + this.filename));
            throw new MalformedSourceException("Error while reading from file " + this.filename);
        }
        return records;
    }

    public RecordSet getRecords(DataLoadingSpec spec) throws MalformedSourceException {
        return this.getRecords();
    }

    public void setFilename(String filename) {
        this.filename = filename;
        try {
            this.openReader();
        }
        catch (EmptySourceException e) {
            logger_.info((Object)("Could not open file " + filename));
            this.reader_ = null;
        }
    }

    protected void finalize() throws Throwable {
        this.reader_.close();
    }

    private void openReader() throws EmptySourceException {
        try {
            this.reader_ = new BufferedReader(new FileReader(this.filename));
        }
        catch (FileNotFoundException e) {
            throw new EmptySourceException("File " + this.filename + " not found");
        }
    }

    public Map<String, String> getFieldMap() {
        return this.field_map_;
    }

    public void setFieldMap(Map<String, String> field_map_) {
        this.field_map_ = field_map_;
    }
}

